/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.packet;

import org.jivesoftware.smack.PacketCollector;
import org.jivesoftware.smack.SmackConfiguration;
import org.jivesoftware.smack.XMPPConnection;
import org.jivesoftware.smack.XMPPException;
import org.jivesoftware.smack.filter.PacketIDFilter;
import org.jivesoftware.smack.packet.IQ;
import org.jivesoftware.smack.provider.IQProvider;
import org.jivesoftware.smack.util.StringUtils;
import org.xmlpull.v1.XmlPullParser;

public class LastActivity
extends IQ {
    public long lastActivity = -1L;
    public String message;

    public LastActivity() {
        this.setType(IQ.Type.GET);
    }

    public String getChildElementXML() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("<query xmlns=\"jabber:iq:last\"");
        if (this.lastActivity != -1L) {
            stringBuilder.append(" seconds=\"").append(this.lastActivity).append("\"");
        }
        stringBuilder.append("></query>");
        return stringBuilder.toString();
    }

    public void setLastActivity(long l) {
        this.lastActivity = l;
    }

    private void setMessage(String string) {
        this.message = string;
    }

    public long getIdleTime() {
        return this.lastActivity;
    }

    public String getStatusMessage() {
        return this.message;
    }

    public static LastActivity getLastActivity(XMPPConnection xMPPConnection, String string) throws XMPPException {
        LastActivity lastActivity = new LastActivity();
        string = StringUtils.parseBareAddress(string);
        lastActivity.setTo(string);
        PacketCollector packetCollector = xMPPConnection.createPacketCollector(new PacketIDFilter(lastActivity.getPacketID()));
        xMPPConnection.sendPacket(lastActivity);
        LastActivity lastActivity2 = (LastActivity)packetCollector.nextResult(SmackConfiguration.getPacketReplyTimeout());
        packetCollector.cancel();
        if (lastActivity2 == null) {
            throw new XMPPException("No response from server on status set.");
        }
        if (lastActivity2.getError() != null) {
            throw new XMPPException(lastActivity2.getError());
        }
        return lastActivity2;
    }

    public static class Provider
    implements IQProvider {
        public IQ parseIQ(XmlPullParser xmlPullParser) throws Exception {
            if (xmlPullParser.getEventType() != 2) {
                throw new IllegalStateException("Parser not in proper position, or bad XML.");
            }
            LastActivity lastActivity = new LastActivity();
            try {
                String string = xmlPullParser.getAttributeValue("", "seconds");
                String string2 = xmlPullParser.nextText();
                if (string != null) {
                    long l = new Double(string).longValue();
                    lastActivity.setLastActivity((int)l);
                }
                if (string2 != null) {
                    lastActivity.setMessage(string2);
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            return lastActivity;
        }
    }
}

