/*
 * Decompiled with CFR 0.152.
 */
package org.jlibrtp.jlibrtp.core;

import java.net.InetAddress;
import org.jlibrtp.jlibrtp.core.Participant;
import org.jlibrtp.jlibrtp.core.ParticipantDatabase;
import org.jlibrtp.jlibrtp.core.StaticProcs;

public class RtcpPkt {
    protected int problem = 0;
    protected int version = 2;
    protected int padding = 0;
    protected int itemCount = 0;
    protected int packetType = -1;
    protected int length = -1;
    protected long ssrc = -1L;
    protected byte[] rawPkt = null;
    protected long time = -1L;
    protected boolean received = false;

    protected boolean parseHeaders(int start) {
        this.version = (this.rawPkt[start + 0] & 0xC0) >>> 6;
        this.padding = (this.rawPkt[start + 0] & 0x20) >>> 5;
        this.itemCount = this.rawPkt[start + 0] & 0x1F;
        this.packetType = this.rawPkt[start + 1];
        if (this.packetType < 0) {
            this.packetType += 256;
        }
        this.length = StaticProcs.bytesToUIntInt(this.rawPkt, start + 2);
        if (this.packetType > 207 || this.packetType < 200) {
            System.out.println("RtcpPkt.parseHeaders problem discovered, packetType " + this.packetType);
        }
        if (this.version == 2 && this.length < 65536) {
            return true;
        }
        System.out.println("RtcpPkt.parseHeaders() failed header checks, check size and version");
        this.problem = -1;
        return false;
    }

    protected void writeHeaders() {
        int aByte = 0;
        aByte = (byte)(aByte | this.version << 6);
        aByte = (byte)(aByte | this.padding << 5);
        this.rawPkt[0] = aByte = (int)((byte)(aByte | this.itemCount));
        aByte = 0;
        this.rawPkt[1] = aByte = (int)((byte)(aByte | this.packetType));
        if (this.rawPkt.length % 4 != 0) {
            System.out.println("!!!! RtcpPkt.writeHeaders() rawPkt was not a multiple of 32 bits / 4 octets!");
        }
        byte[] someBytes = StaticProcs.uIntIntToByteWord(this.rawPkt.length / 4 - 1);
        this.rawPkt[2] = someBytes[0];
        this.rawPkt[3] = someBytes[1];
    }

    protected void encode() {
        System.out.println("RtcpPkt.encode() should never be invoked!! " + this.packetType);
    }

    protected boolean check(InetAddress adr, ParticipantDatabase partDb) {
        if (partDb.rtpSession.mcSession && adr.equals(partDb.rtpSession.mcGroup)) {
            return true;
        }
        Participant part = partDb.getParticipant(this.ssrc);
        return part != null && part.rtcpAddress.getAddress().equals(adr);
    }
}

