/**
 * 
 */
package com.beem.project.beem.service;

import java.util.ArrayList;
import java.util.List;

import org.jivesoftware.smack.PrivacyListListener;
import org.jivesoftware.smack.PrivacyListManager;
import org.jivesoftware.smack.XMPPConnection;
import org.jivesoftware.smack.XMPPException;
import org.jivesoftware.smack.packet.PrivacyItem;

import android.os.RemoteException;
import android.util.Log;

import com.beem.project.beem.service.aidl.IPrivacyListManager;

/**
 * @author nikita
 *
 */
public class PrivacyListManagerAdapter extends IPrivacyListManager.Stub {
    public static final String TAG = "PrivacyListManagerAdapter";
    private PrivacyListManager mAdaptee = null;
    private List<String> mBlockedUser = new ArrayList<String>();
    private XMPPConnection mConnection;
    
    public PrivacyListManagerAdapter(XMPPConnection connection) {
	mConnection = connection;
    }
    
    public List<String> getBlockedUsers() {
	return mBlockedUser;
    }
    
    public void addBlockedUser(String jid) {
	if (mAdaptee == null) {
	    PrivacyListManager.getInstanceFor(mConnection);
	    if (mAdaptee == null) {
		Log.e(TAG, "pas bon");
	    }
	    mAdaptee.addListener(new MyPrivacyListListener());
	}
	    
	Log.d(TAG, "addBlockedUser");
	PrivacyItem pItem = new PrivacyItem("jid", false, 0);
	pItem.setValue(jid);
	pItem.setFilterPresence_out(false);
	List<PrivacyItem> pItemList = new ArrayList<PrivacyItem>();
	pItemList.add(pItem);
	try {
	    mAdaptee.createPrivacyList(jid, pItemList);
	} catch (XMPPException e) {
	    // TODO Auto-generated catch block
	    e.printStackTrace();
	}
    }
    
    class MyPrivacyListListener implements PrivacyListListener {

	@Override
	public void setPrivacyList(String listName, List<PrivacyItem> listItem) {
	    Log.d(TAG,"setPrivacyList");
	    
	}

	@Override
	public void updatedPrivacyList(String listName) {
	    Log.d(TAG,"updatedPrivacyList");
	    
	}	
    }

    @Override
    public List<String> getBlockedUsersByList(String listName) throws RemoteException {
	// TODO Auto-generated method stub
	return null;
    }

    public PrivacyListManager getManager() {
	return mAdaptee;
    }   
}
