/*
 * Decompiled with CFR 0.152.
 */
package org.xbill.DNS.utils;

import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;

public class HMAC {
    MessageDigest digest;
    private byte[] ipad;
    private byte[] opad;
    private static final byte IPAD = 54;
    private static final byte OPAD = 92;
    private static final byte PADLEN = 64;

    private void init(byte[] byArray) {
        int n;
        if (byArray.length > 64) {
            byArray = this.digest.digest(byArray);
            this.digest.reset();
        }
        this.ipad = new byte[64];
        this.opad = new byte[64];
        for (n = 0; n < byArray.length; ++n) {
            this.ipad[n] = (byte)(byArray[n] ^ 0x36);
            this.opad[n] = (byte)(byArray[n] ^ 0x5C);
        }
        while (n < 64) {
            this.ipad[n] = 54;
            this.opad[n] = 92;
            ++n;
        }
        this.digest.update(this.ipad);
    }

    public HMAC(MessageDigest messageDigest, byte[] byArray) {
        messageDigest.reset();
        this.digest = messageDigest;
        this.init(byArray);
    }

    public HMAC(String string, byte[] byArray) {
        try {
            this.digest = MessageDigest.getInstance(string);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new IllegalArgumentException("unknown digest algorithm " + string);
        }
        this.init(byArray);
    }

    public void update(byte[] byArray, int n, int n2) {
        this.digest.update(byArray, n, n2);
    }

    public void update(byte[] byArray) {
        this.digest.update(byArray);
    }

    public byte[] sign() {
        byte[] byArray = this.digest.digest();
        this.digest.reset();
        this.digest.update(this.opad);
        return this.digest.digest(byArray);
    }

    public boolean verify(byte[] byArray) {
        return Arrays.equals(byArray, this.sign());
    }

    public void clear() {
        this.digest.reset();
        this.digest.update(this.ipad);
    }
}

