/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.workgroup.agent;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jivesoftware.smack.Connection;
import org.jivesoftware.smack.PacketCollector;
import org.jivesoftware.smack.PacketListener;
import org.jivesoftware.smack.SmackConfiguration;
import org.jivesoftware.smack.XMPPException;
import org.jivesoftware.smack.filter.AndFilter;
import org.jivesoftware.smack.filter.FromContainsFilter;
import org.jivesoftware.smack.filter.OrFilter;
import org.jivesoftware.smack.filter.PacketIDFilter;
import org.jivesoftware.smack.filter.PacketTypeFilter;
import org.jivesoftware.smack.packet.DefaultPacketExtension;
import org.jivesoftware.smack.packet.IQ;
import org.jivesoftware.smack.packet.Message;
import org.jivesoftware.smack.packet.Packet;
import org.jivesoftware.smack.packet.Presence;
import org.jivesoftware.smack.util.StringUtils;
import org.jivesoftware.smackx.Form;
import org.jivesoftware.smackx.ReportedData;
import org.jivesoftware.smackx.packet.MUCUser;
import org.jivesoftware.smackx.workgroup.MetaData;
import org.jivesoftware.smackx.workgroup.WorkgroupInvitation;
import org.jivesoftware.smackx.workgroup.WorkgroupInvitationListener;
import org.jivesoftware.smackx.workgroup.agent.Agent;
import org.jivesoftware.smackx.workgroup.agent.AgentRoster;
import org.jivesoftware.smackx.workgroup.agent.Offer;
import org.jivesoftware.smackx.workgroup.agent.OfferListener;
import org.jivesoftware.smackx.workgroup.agent.QueueUsersListener;
import org.jivesoftware.smackx.workgroup.agent.RevokedOffer;
import org.jivesoftware.smackx.workgroup.agent.TranscriptManager;
import org.jivesoftware.smackx.workgroup.agent.TranscriptSearchManager;
import org.jivesoftware.smackx.workgroup.agent.WorkgroupQueue;
import org.jivesoftware.smackx.workgroup.ext.history.AgentChatHistory;
import org.jivesoftware.smackx.workgroup.ext.history.ChatMetadata;
import org.jivesoftware.smackx.workgroup.ext.macros.MacroGroup;
import org.jivesoftware.smackx.workgroup.ext.macros.Macros;
import org.jivesoftware.smackx.workgroup.ext.notes.ChatNotes;
import org.jivesoftware.smackx.workgroup.packet.DepartQueuePacket;
import org.jivesoftware.smackx.workgroup.packet.MonitorPacket;
import org.jivesoftware.smackx.workgroup.packet.OccupantsInfo;
import org.jivesoftware.smackx.workgroup.packet.OfferRequestProvider;
import org.jivesoftware.smackx.workgroup.packet.OfferRevokeProvider;
import org.jivesoftware.smackx.workgroup.packet.QueueDetails;
import org.jivesoftware.smackx.workgroup.packet.QueueOverview;
import org.jivesoftware.smackx.workgroup.packet.RoomInvitation;
import org.jivesoftware.smackx.workgroup.packet.RoomTransfer;
import org.jivesoftware.smackx.workgroup.packet.SessionID;
import org.jivesoftware.smackx.workgroup.packet.Transcript;
import org.jivesoftware.smackx.workgroup.packet.Transcripts;
import org.jivesoftware.smackx.workgroup.settings.GenericSettings;
import org.jivesoftware.smackx.workgroup.settings.SearchSettings;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AgentSession {
    private Connection connection;
    private String workgroupJID;
    private boolean online = false;
    private Presence.Mode presenceMode;
    private int maxChats;
    private final Map<String, String> metaData;
    private Map<String, WorkgroupQueue> queues;
    private final List<OfferListener> offerListeners;
    private final List<WorkgroupInvitationListener> invitationListeners;
    private final List<QueueUsersListener> queueUsersListeners;
    private AgentRoster agentRoster = null;
    private TranscriptManager transcriptManager;
    private TranscriptSearchManager transcriptSearchManager;
    private Agent agent;
    private PacketListener packetListener;

    public AgentSession(String string, Connection connection) {
        if (!connection.isAuthenticated()) {
            throw new IllegalStateException("Must login to server before creating workgroup.");
        }
        this.workgroupJID = string;
        this.connection = connection;
        this.transcriptManager = new TranscriptManager(connection);
        this.transcriptSearchManager = new TranscriptSearchManager(connection);
        this.maxChats = -1;
        this.metaData = new HashMap<String, String>();
        this.queues = new HashMap<String, WorkgroupQueue>();
        this.offerListeners = new ArrayList<OfferListener>();
        this.invitationListeners = new ArrayList<WorkgroupInvitationListener>();
        this.queueUsersListeners = new ArrayList<QueueUsersListener>();
        OrFilter orFilter = new OrFilter();
        orFilter.addFilter(new PacketTypeFilter(OfferRequestProvider.OfferRequestPacket.class));
        orFilter.addFilter(new PacketTypeFilter(OfferRevokeProvider.OfferRevokePacket.class));
        orFilter.addFilter(new PacketTypeFilter(Presence.class));
        orFilter.addFilter(new PacketTypeFilter(Message.class));
        this.packetListener = new PacketListener(){

            public void processPacket(Packet packet) {
                try {
                    AgentSession.this.handlePacket(packet);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        };
        connection.addPacketListener(this.packetListener, orFilter);
        this.agent = new Agent(connection, string);
    }

    public void close() {
        this.connection.removePacketListener(this.packetListener);
    }

    public AgentRoster getAgentRoster() {
        if (this.agentRoster == null) {
            this.agentRoster = new AgentRoster(this.connection, this.workgroupJID);
        }
        for (int i = 0; !this.agentRoster.rosterInitialized && i <= 2000; i += 500) {
            try {
                Thread.sleep(500L);
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return this.agentRoster;
    }

    public Presence.Mode getPresenceMode() {
        return this.presenceMode;
    }

    public int getMaxChats() {
        return this.maxChats;
    }

    public boolean isOnline() {
        return this.online;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setMetaData(String string, String string2) throws XMPPException {
        Map<String, String> map = this.metaData;
        synchronized (map) {
            String string3 = this.metaData.get(string);
            if (string3 == null || !string3.equals(string2)) {
                this.metaData.put(string, string2);
                this.setStatus(this.presenceMode, this.maxChats);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeMetaData(String string) throws XMPPException {
        Map<String, String> map = this.metaData;
        synchronized (map) {
            String string2 = this.metaData.remove(string);
            if (string2 != null) {
                this.setStatus(this.presenceMode, this.maxChats);
            }
        }
    }

    public String getMetaData(String string) {
        return this.metaData.get(string);
    }

    public void setOnline(boolean bl) throws XMPPException {
        if (this.online == bl) {
            return;
        }
        if (bl) {
            Presence presence = new Presence(Presence.Type.available);
            presence.setTo(this.workgroupJID);
            presence.addExtension(new DefaultPacketExtension("agent-status", "http://jabber.org/protocol/workgroup"));
            PacketCollector packetCollector = this.connection.createPacketCollector(new AndFilter(new PacketTypeFilter(Presence.class), new FromContainsFilter(this.workgroupJID)));
            this.connection.sendPacket(presence);
            presence = (Presence)packetCollector.nextResult(5000L);
            packetCollector.cancel();
            if (!presence.isAvailable()) {
                throw new XMPPException("No response from server on status set.");
            }
            if (presence.getError() != null) {
                throw new XMPPException(presence.getError());
            }
            this.online = bl;
        } else {
            this.online = bl;
            Presence presence = new Presence(Presence.Type.unavailable);
            presence.setTo(this.workgroupJID);
            presence.addExtension(new DefaultPacketExtension("agent-status", "http://jabber.org/protocol/workgroup"));
            this.connection.sendPacket(presence);
        }
    }

    public void setStatus(Presence.Mode mode, int n) throws XMPPException {
        this.setStatus(mode, n, null);
    }

    public void setStatus(Presence.Mode mode, int n, String string) throws XMPPException {
        if (!this.online) {
            throw new IllegalStateException("Cannot set status when the agent is not online.");
        }
        if (mode == null) {
            mode = Presence.Mode.available;
        }
        this.presenceMode = mode;
        this.maxChats = n;
        Presence presence = new Presence(Presence.Type.available);
        presence.setMode(mode);
        presence.setTo(this.getWorkgroupJID());
        if (string != null) {
            presence.setStatus(string);
        }
        DefaultPacketExtension defaultPacketExtension = new DefaultPacketExtension("agent-status", "http://jabber.org/protocol/workgroup");
        defaultPacketExtension.setValue("max-chats", "" + n);
        presence.addExtension(defaultPacketExtension);
        presence.addExtension(new MetaData(this.metaData));
        PacketCollector packetCollector = this.connection.createPacketCollector(new AndFilter(new PacketTypeFilter(Presence.class), new FromContainsFilter(this.workgroupJID)));
        this.connection.sendPacket(presence);
        presence = (Presence)packetCollector.nextResult(5000L);
        packetCollector.cancel();
        if (!presence.isAvailable()) {
            throw new XMPPException("No response from server on status set.");
        }
        if (presence.getError() != null) {
            throw new XMPPException(presence.getError());
        }
    }

    public void setStatus(Presence.Mode mode, String string) throws XMPPException {
        if (!this.online) {
            throw new IllegalStateException("Cannot set status when the agent is not online.");
        }
        if (mode == null) {
            mode = Presence.Mode.available;
        }
        this.presenceMode = mode;
        Presence presence = new Presence(Presence.Type.available);
        presence.setMode(mode);
        presence.setTo(this.getWorkgroupJID());
        if (string != null) {
            presence.setStatus(string);
        }
        presence.addExtension(new MetaData(this.metaData));
        PacketCollector packetCollector = this.connection.createPacketCollector(new AndFilter(new PacketTypeFilter(Presence.class), new FromContainsFilter(this.workgroupJID)));
        this.connection.sendPacket(presence);
        presence = (Presence)packetCollector.nextResult(5000L);
        packetCollector.cancel();
        if (!presence.isAvailable()) {
            throw new XMPPException("No response from server on status set.");
        }
        if (presence.getError() != null) {
            throw new XMPPException(presence.getError());
        }
    }

    public void dequeueUser(String string) throws XMPPException {
        DepartQueuePacket departQueuePacket = new DepartQueuePacket(this.workgroupJID);
        this.connection.sendPacket(departQueuePacket);
    }

    public Transcripts getTranscripts(String string) throws XMPPException {
        return this.transcriptManager.getTranscripts(this.workgroupJID, string);
    }

    public Transcript getTranscript(String string) throws XMPPException {
        return this.transcriptManager.getTranscript(this.workgroupJID, string);
    }

    public Form getTranscriptSearchForm() throws XMPPException {
        return this.transcriptSearchManager.getSearchForm(StringUtils.parseServer(this.workgroupJID));
    }

    public ReportedData searchTranscripts(Form form) throws XMPPException {
        return this.transcriptSearchManager.submitSearch(StringUtils.parseServer(this.workgroupJID), form);
    }

    public OccupantsInfo getOccupantsInfo(String string) throws XMPPException {
        OccupantsInfo occupantsInfo = new OccupantsInfo(string);
        occupantsInfo.setType(IQ.Type.GET);
        occupantsInfo.setTo(this.workgroupJID);
        PacketCollector packetCollector = this.connection.createPacketCollector(new PacketIDFilter(occupantsInfo.getPacketID()));
        this.connection.sendPacket(occupantsInfo);
        OccupantsInfo occupantsInfo2 = (OccupantsInfo)packetCollector.nextResult(SmackConfiguration.getPacketReplyTimeout());
        packetCollector.cancel();
        if (occupantsInfo2 == null) {
            throw new XMPPException("No response from server.");
        }
        if (occupantsInfo2.getError() != null) {
            throw new XMPPException(occupantsInfo2.getError());
        }
        return occupantsInfo2;
    }

    public String getWorkgroupJID() {
        return this.workgroupJID;
    }

    public Agent getAgent() {
        return this.agent;
    }

    public WorkgroupQueue getQueue(String string) {
        return this.queues.get(string);
    }

    public Iterator<WorkgroupQueue> getQueues() {
        return Collections.unmodifiableMap(new HashMap<String, WorkgroupQueue>(this.queues)).values().iterator();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addQueueUsersListener(QueueUsersListener queueUsersListener) {
        List<QueueUsersListener> list = this.queueUsersListeners;
        synchronized (list) {
            if (!this.queueUsersListeners.contains(queueUsersListener)) {
                this.queueUsersListeners.add(queueUsersListener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeQueueUsersListener(QueueUsersListener queueUsersListener) {
        List<QueueUsersListener> list = this.queueUsersListeners;
        synchronized (list) {
            this.queueUsersListeners.remove(queueUsersListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addOfferListener(OfferListener offerListener) {
        List<OfferListener> list = this.offerListeners;
        synchronized (list) {
            if (!this.offerListeners.contains(offerListener)) {
                this.offerListeners.add(offerListener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeOfferListener(OfferListener offerListener) {
        List<OfferListener> list = this.offerListeners;
        synchronized (list) {
            this.offerListeners.remove(offerListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addInvitationListener(WorkgroupInvitationListener workgroupInvitationListener) {
        List<WorkgroupInvitationListener> list = this.invitationListeners;
        synchronized (list) {
            if (!this.invitationListeners.contains(workgroupInvitationListener)) {
                this.invitationListeners.add(workgroupInvitationListener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeInvitationListener(WorkgroupInvitationListener workgroupInvitationListener) {
        List<WorkgroupInvitationListener> list = this.invitationListeners;
        synchronized (list) {
            this.invitationListeners.remove(workgroupInvitationListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireOfferRequestEvent(OfferRequestProvider.OfferRequestPacket offerRequestPacket) {
        Offer offer = new Offer(this.connection, this, offerRequestPacket.getUserID(), offerRequestPacket.getUserJID(), this.getWorkgroupJID(), new Date(new Date().getTime() + (long)(offerRequestPacket.getTimeout() * 1000)), offerRequestPacket.getSessionID(), offerRequestPacket.getMetaData(), offerRequestPacket.getContent());
        List<OfferListener> list = this.offerListeners;
        synchronized (list) {
            for (OfferListener offerListener : this.offerListeners) {
                offerListener.offerReceived(offer);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireOfferRevokeEvent(OfferRevokeProvider.OfferRevokePacket offerRevokePacket) {
        RevokedOffer revokedOffer = new RevokedOffer(offerRevokePacket.getUserJID(), offerRevokePacket.getUserID(), this.getWorkgroupJID(), offerRevokePacket.getSessionID(), offerRevokePacket.getReason(), new Date());
        List<OfferListener> list = this.offerListeners;
        synchronized (list) {
            for (OfferListener offerListener : this.offerListeners) {
                offerListener.offerRevoked(revokedOffer);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireInvitationEvent(String string, String string2, String string3, String string4, Map map) {
        WorkgroupInvitation workgroupInvitation = new WorkgroupInvitation(this.connection.getUser(), string, this.workgroupJID, string2, string3, string4, map);
        List<WorkgroupInvitationListener> list = this.invitationListeners;
        synchronized (list) {
            for (WorkgroupInvitationListener workgroupInvitationListener : this.invitationListeners) {
                workgroupInvitationListener.invitationReceived(workgroupInvitation);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireQueueUsersEvent(WorkgroupQueue workgroupQueue, WorkgroupQueue.Status status, int n, Date date, Set set) {
        List<QueueUsersListener> list = this.queueUsersListeners;
        synchronized (list) {
            for (QueueUsersListener queueUsersListener : this.queueUsersListeners) {
                if (status != null) {
                    queueUsersListener.statusUpdated(workgroupQueue, status);
                }
                if (n != -1) {
                    queueUsersListener.averageWaitTimeUpdated(workgroupQueue, n);
                }
                if (date != null) {
                    queueUsersListener.oldestEntryUpdated(workgroupQueue, date);
                }
                if (set == null) continue;
                queueUsersListener.usersUpdated(workgroupQueue, set);
            }
        }
    }

    private void handlePacket(Packet packet) {
        if (packet instanceof OfferRequestProvider.OfferRequestPacket) {
            IQ iQ = new IQ(){

                public String getChildElementXML() {
                    return null;
                }
            };
            iQ.setPacketID(packet.getPacketID());
            iQ.setTo(packet.getFrom());
            iQ.setType(IQ.Type.RESULT);
            this.connection.sendPacket(iQ);
            this.fireOfferRequestEvent((OfferRequestProvider.OfferRequestPacket)packet);
        } else if (packet instanceof Presence) {
            QueueOverview queueOverview;
            Presence presence = (Presence)packet;
            String string = StringUtils.parseResource(presence.getFrom());
            WorkgroupQueue workgroupQueue = this.queues.get(string);
            if (workgroupQueue == null) {
                workgroupQueue = new WorkgroupQueue(string);
                this.queues.put(string, workgroupQueue);
            }
            if ((queueOverview = (QueueOverview)presence.getExtension(QueueOverview.ELEMENT_NAME, QueueOverview.NAMESPACE)) != null) {
                if (queueOverview.getStatus() == null) {
                    workgroupQueue.setStatus(WorkgroupQueue.Status.CLOSED);
                } else {
                    workgroupQueue.setStatus(queueOverview.getStatus());
                }
                workgroupQueue.setAverageWaitTime(queueOverview.getAverageWaitTime());
                workgroupQueue.setOldestEntry(queueOverview.getOldestEntry());
                this.fireQueueUsersEvent(workgroupQueue, queueOverview.getStatus(), queueOverview.getAverageWaitTime(), queueOverview.getOldestEntry(), null);
                return;
            }
            QueueDetails queueDetails = (QueueDetails)packet.getExtension("notify-queue-details", "http://jabber.org/protocol/workgroup");
            if (queueDetails != null) {
                workgroupQueue.setUsers(queueDetails.getUsers());
                this.fireQueueUsersEvent(workgroupQueue, null, -1, null, queueDetails.getUsers());
                return;
            }
            DefaultPacketExtension defaultPacketExtension = (DefaultPacketExtension)presence.getExtension("notify-agents", "http://jabber.org/protocol/workgroup");
            if (defaultPacketExtension != null) {
                int n = Integer.parseInt(defaultPacketExtension.getValue("current-chats"));
                int n2 = Integer.parseInt(defaultPacketExtension.getValue("max-chats"));
                workgroupQueue.setCurrentChats(n);
                workgroupQueue.setMaxChats(n2);
                return;
            }
        } else if (packet instanceof Message) {
            MUCUser.Invite invite;
            Message message = (Message)packet;
            MUCUser mUCUser = (MUCUser)message.getExtension("x", "http://jabber.org/protocol/muc#user");
            MUCUser.Invite invite2 = invite = mUCUser != null ? mUCUser.getInvite() : null;
            if (invite != null && this.workgroupJID.equals(invite.getFrom())) {
                MetaData metaData;
                String string = null;
                Map map = null;
                SessionID sessionID = (SessionID)message.getExtension("session", "http://jivesoftware.com/protocol/workgroup");
                if (sessionID != null) {
                    string = sessionID.getSessionID();
                }
                if ((metaData = (MetaData)message.getExtension("metadata", "http://jivesoftware.com/protocol/workgroup")) != null) {
                    map = metaData.getMetaData();
                }
                this.fireInvitationEvent(message.getFrom(), string, message.getBody(), message.getFrom(), map);
            }
        } else if (packet instanceof OfferRevokeProvider.OfferRevokePacket) {
            IQ iQ = new IQ(){

                public String getChildElementXML() {
                    return null;
                }
            };
            iQ.setPacketID(packet.getPacketID());
            iQ.setType(IQ.Type.RESULT);
            this.connection.sendPacket(iQ);
            this.fireOfferRevokeEvent((OfferRevokeProvider.OfferRevokePacket)packet);
        }
    }

    public void setNote(String string, String string2) throws XMPPException {
        string2 = ChatNotes.replace(string2, "\n", "\\n");
        string2 = StringUtils.escapeForXML(string2);
        ChatNotes chatNotes = new ChatNotes();
        chatNotes.setType(IQ.Type.SET);
        chatNotes.setTo(this.workgroupJID);
        chatNotes.setSessionID(string);
        chatNotes.setNotes(string2);
        PacketCollector packetCollector = this.connection.createPacketCollector(new PacketIDFilter(chatNotes.getPacketID()));
        this.connection.sendPacket(chatNotes);
        IQ iQ = (IQ)packetCollector.nextResult(SmackConfiguration.getPacketReplyTimeout());
        packetCollector.cancel();
        if (iQ == null) {
            throw new XMPPException("No response from server on status set.");
        }
        if (iQ.getError() != null) {
            throw new XMPPException(iQ.getError());
        }
    }

    public ChatNotes getNote(String string) throws XMPPException {
        ChatNotes chatNotes = new ChatNotes();
        chatNotes.setType(IQ.Type.GET);
        chatNotes.setTo(this.workgroupJID);
        chatNotes.setSessionID(string);
        PacketCollector packetCollector = this.connection.createPacketCollector(new PacketIDFilter(chatNotes.getPacketID()));
        this.connection.sendPacket(chatNotes);
        ChatNotes chatNotes2 = (ChatNotes)packetCollector.nextResult(SmackConfiguration.getPacketReplyTimeout());
        packetCollector.cancel();
        if (chatNotes2 == null) {
            throw new XMPPException("No response from server.");
        }
        if (chatNotes2.getError() != null) {
            throw new XMPPException(chatNotes2.getError());
        }
        return chatNotes2;
    }

    public AgentChatHistory getAgentHistory(String string, int n, Date date) throws XMPPException {
        AgentChatHistory agentChatHistory = date != null ? new AgentChatHistory(string, n, date) : new AgentChatHistory(string, n);
        agentChatHistory.setType(IQ.Type.GET);
        agentChatHistory.setTo(this.workgroupJID);
        PacketCollector packetCollector = this.connection.createPacketCollector(new PacketIDFilter(agentChatHistory.getPacketID()));
        this.connection.sendPacket(agentChatHistory);
        AgentChatHistory agentChatHistory2 = (AgentChatHistory)packetCollector.nextResult(SmackConfiguration.getPacketReplyTimeout());
        packetCollector.cancel();
        if (agentChatHistory2 == null) {
            throw new XMPPException("No response from server.");
        }
        if (agentChatHistory2.getError() != null) {
            throw new XMPPException(agentChatHistory2.getError());
        }
        return agentChatHistory2;
    }

    public SearchSettings getSearchSettings() throws XMPPException {
        SearchSettings searchSettings = new SearchSettings();
        searchSettings.setType(IQ.Type.GET);
        searchSettings.setTo(this.workgroupJID);
        PacketCollector packetCollector = this.connection.createPacketCollector(new PacketIDFilter(searchSettings.getPacketID()));
        this.connection.sendPacket(searchSettings);
        SearchSettings searchSettings2 = (SearchSettings)packetCollector.nextResult(SmackConfiguration.getPacketReplyTimeout());
        packetCollector.cancel();
        if (searchSettings2 == null) {
            throw new XMPPException("No response from server.");
        }
        if (searchSettings2.getError() != null) {
            throw new XMPPException(searchSettings2.getError());
        }
        return searchSettings2;
    }

    public MacroGroup getMacros(boolean bl) throws XMPPException {
        Macros macros = new Macros();
        macros.setType(IQ.Type.GET);
        macros.setTo(this.workgroupJID);
        macros.setPersonal(!bl);
        PacketCollector packetCollector = this.connection.createPacketCollector(new PacketIDFilter(macros.getPacketID()));
        this.connection.sendPacket(macros);
        Macros macros2 = (Macros)packetCollector.nextResult(SmackConfiguration.getPacketReplyTimeout());
        packetCollector.cancel();
        if (macros2 == null) {
            throw new XMPPException("No response from server.");
        }
        if (macros2.getError() != null) {
            throw new XMPPException(macros2.getError());
        }
        return macros2.getRootGroup();
    }

    public void saveMacros(MacroGroup macroGroup) throws XMPPException {
        Macros macros = new Macros();
        macros.setType(IQ.Type.SET);
        macros.setTo(this.workgroupJID);
        macros.setPersonal(true);
        macros.setPersonalMacroGroup(macroGroup);
        PacketCollector packetCollector = this.connection.createPacketCollector(new PacketIDFilter(macros.getPacketID()));
        this.connection.sendPacket(macros);
        IQ iQ = (IQ)packetCollector.nextResult(SmackConfiguration.getPacketReplyTimeout());
        packetCollector.cancel();
        if (iQ == null) {
            throw new XMPPException("No response from server on status set.");
        }
        if (iQ.getError() != null) {
            throw new XMPPException(iQ.getError());
        }
    }

    public Map getChatMetadata(String string) throws XMPPException {
        ChatMetadata chatMetadata = new ChatMetadata();
        chatMetadata.setType(IQ.Type.GET);
        chatMetadata.setTo(this.workgroupJID);
        chatMetadata.setSessionID(string);
        PacketCollector packetCollector = this.connection.createPacketCollector(new PacketIDFilter(chatMetadata.getPacketID()));
        this.connection.sendPacket(chatMetadata);
        ChatMetadata chatMetadata2 = (ChatMetadata)packetCollector.nextResult(SmackConfiguration.getPacketReplyTimeout());
        packetCollector.cancel();
        if (chatMetadata2 == null) {
            throw new XMPPException("No response from server.");
        }
        if (chatMetadata2.getError() != null) {
            throw new XMPPException(chatMetadata2.getError());
        }
        return chatMetadata2.getMetadata();
    }

    public void sendRoomInvitation(RoomInvitation.Type type, String string, String string2, String string3) throws XMPPException {
        final RoomInvitation roomInvitation = new RoomInvitation(type, string, string2, string3);
        IQ iQ = new IQ(){

            public String getChildElementXML() {
                return roomInvitation.toXML();
            }
        };
        iQ.setType(IQ.Type.SET);
        iQ.setTo(this.workgroupJID);
        iQ.setFrom(this.connection.getUser());
        PacketCollector packetCollector = this.connection.createPacketCollector(new PacketIDFilter(iQ.getPacketID()));
        this.connection.sendPacket(iQ);
        IQ iQ2 = (IQ)packetCollector.nextResult(SmackConfiguration.getPacketReplyTimeout());
        packetCollector.cancel();
        if (iQ2 == null) {
            throw new XMPPException("No response from server.");
        }
        if (iQ2.getError() != null) {
            throw new XMPPException(iQ2.getError());
        }
    }

    public void sendRoomTransfer(RoomTransfer.Type type, String string, String string2, String string3) throws XMPPException {
        final RoomTransfer roomTransfer = new RoomTransfer(type, string, string2, string3);
        IQ iQ = new IQ(){

            public String getChildElementXML() {
                return roomTransfer.toXML();
            }
        };
        iQ.setType(IQ.Type.SET);
        iQ.setTo(this.workgroupJID);
        iQ.setFrom(this.connection.getUser());
        PacketCollector packetCollector = this.connection.createPacketCollector(new PacketIDFilter(iQ.getPacketID()));
        this.connection.sendPacket(iQ);
        IQ iQ2 = (IQ)packetCollector.nextResult(SmackConfiguration.getPacketReplyTimeout());
        packetCollector.cancel();
        if (iQ2 == null) {
            throw new XMPPException("No response from server.");
        }
        if (iQ2.getError() != null) {
            throw new XMPPException(iQ2.getError());
        }
    }

    public GenericSettings getGenericSettings(Connection connection, String string) throws XMPPException {
        GenericSettings genericSettings = new GenericSettings();
        genericSettings.setType(IQ.Type.GET);
        genericSettings.setTo(this.workgroupJID);
        PacketCollector packetCollector = this.connection.createPacketCollector(new PacketIDFilter(genericSettings.getPacketID()));
        this.connection.sendPacket(genericSettings);
        GenericSettings genericSettings2 = (GenericSettings)packetCollector.nextResult(SmackConfiguration.getPacketReplyTimeout());
        packetCollector.cancel();
        if (genericSettings2 == null) {
            throw new XMPPException("No response from server on status set.");
        }
        if (genericSettings2.getError() != null) {
            throw new XMPPException(genericSettings2.getError());
        }
        return genericSettings2;
    }

    public boolean hasMonitorPrivileges(Connection connection) throws XMPPException {
        MonitorPacket monitorPacket = new MonitorPacket();
        monitorPacket.setType(IQ.Type.GET);
        monitorPacket.setTo(this.workgroupJID);
        PacketCollector packetCollector = this.connection.createPacketCollector(new PacketIDFilter(monitorPacket.getPacketID()));
        this.connection.sendPacket(monitorPacket);
        MonitorPacket monitorPacket2 = (MonitorPacket)packetCollector.nextResult(SmackConfiguration.getPacketReplyTimeout());
        packetCollector.cancel();
        if (monitorPacket2 == null) {
            throw new XMPPException("No response from server on status set.");
        }
        if (monitorPacket2.getError() != null) {
            throw new XMPPException(monitorPacket2.getError());
        }
        return monitorPacket2.isMonitor();
    }

    public void makeRoomOwner(Connection connection, String string) throws XMPPException {
        MonitorPacket monitorPacket = new MonitorPacket();
        monitorPacket.setType(IQ.Type.SET);
        monitorPacket.setTo(this.workgroupJID);
        monitorPacket.setSessionID(string);
        PacketCollector packetCollector = this.connection.createPacketCollector(new PacketIDFilter(monitorPacket.getPacketID()));
        this.connection.sendPacket(monitorPacket);
        Packet packet = packetCollector.nextResult(SmackConfiguration.getPacketReplyTimeout());
        packetCollector.cancel();
        if (packet == null) {
            throw new XMPPException("No response from server on status set.");
        }
        if (packet.getError() != null) {
            throw new XMPPException(packet.getError());
        }
    }
}

