package com.beem.project.beem;

import com.beem.project.beem.service.aidl.IBeemConnectionListener;
import com.beem.project.beem.service.aidl.IXMPPConnection;
import com.beem.project.beem.service.aidl.IXMPPFacade;

import android.app.Activity;
import android.content.ComponentName;
import android.content.Intent;
import android.content.ServiceConnection;
import android.content.SharedPreferences;
import android.os.Bundle;
import android.os.Handler;
import android.os.IBinder;
import android.os.Message;
import android.os.RemoteException;
import android.util.Log;
import android.view.Menu;
import android.view.MenuInflater;
import android.view.MenuItem;
import android.view.View;
import android.view.View.OnClickListener;
import android.widget.Button;
import android.widget.EditText;
import android.widget.Toast;

public class Beem extends Activity {
    
    private SharedPreferences mSettings;

    private IXMPPFacade facade; 
    
    private Handler mHandler;
    
    /** 
     * Called when the activity is first created.
     */
    @Override
    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        mHandler = new Handler();
        setContentView(R.layout.main);
        mSettings = getSharedPreferences(getString(R.string.PreferenceFileName), MODE_PRIVATE);
        showJID();
        Button btConnection = (Button) findViewById(R.id.connection);
        btConnection.setOnClickListener(new OnClickListener() {
           
	    @Override
	    public void onClick(View v) {
		// TODO Auto-generated method stub
	//	startService(new Intent(Beem.this,BeemService.class));
		boolean ok = bindService(new Intent(Beem.this,BeemService.class), new ServiceConnection() {
		
		    @Override
		    public void onServiceDisconnected(ComponentName name) {
			// TODO Auto-generated method stub
		
		    }
		
		    @Override
		    public void onServiceConnected(ComponentName name, IBinder service) {
			// TODO Auto-generated method stub
			try {
				facade = (IXMPPFacade) service;
				IXMPPConnection con = facade.getXMPPConnection();
				con.addConnectionListener(new IBeemConnectionListener.Stub() {
					
				    @Override
				    public void reconnectionSuccessful() throws RemoteException {
					// TODO Auto-generated method stub
				
				    }
				
				    @Override
				    public void reconnectionFailed() throws RemoteException {
					// TODO Auto-generated method stub
				
				    }
				
				    @Override
				    public void reconnectingIn(int seconds) throws RemoteException {
					// TODO Auto-generated method stub
				
				    }
				
				    @Override
				    public void onConnect() throws RemoteException {
					// TODO Auto-generated method stub
					mHandler.post(new Runnable() {
					
					    @Override
					    public void run() {
						// TODO Auto-generated method stub
						Log.w("BEEM", "ON s'est COnnecter !!!");
						Toast toast = Toast.makeText(Beem.this, "Connection estabished", Toast.LENGTH_LONG);
						toast.show();
					    }
					});
					
				    }
				
				    @Override
				    public void connectionClosedOnError() throws RemoteException {
					// TODO Auto-generated method stub
				
				    }
				
				    @Override
				    public void connectionClosed() throws RemoteException {
					// TODO Auto-generated method stub
				
				    }
				});
				facade.connectAsync();
			} catch (RemoteException e) {
			    // TODO Auto-generated catch block
			    e.printStackTrace();
			}
		    }
		}, BIND_AUTO_CREATE);
		if (! ok)
		    Log.w("BEEM", "Connection au service echoue");
	    }
        });
    }
    
    @Override
    public boolean onCreateOptionsMenu(Menu menu) {
        super.onCreateOptionsMenu(menu);
        MenuInflater inflater = getMenuInflater();
        inflater.inflate(R.menu.account, menu);
        return true;
    }

    @Override
    public boolean onOptionsItemSelected(MenuItem item) {
        SettingsDialog Dialog = new SettingsDialog(this, mSettings);
        switch (item.getItemId()) {        
        case R.id.account_edit:
            Dialog.show();
            return true;
        case R.id.account_about:
            return true;
        }
        return false;
    }

    public void showJID() {
        EditText ejid = (EditText) findViewById(R.id.jid);
        String jid = mSettings.getString("login", "") +
            "@" +  mSettings.getString("host", "") ;
        if (jid.length() == 1)
            jid = "Enter Jabber ID / Create New Account";
        ejid.setText(jid);
    }
    

    private class TestHandler extends Handler{
	
	@Override
	public void handleMessage(Message msg) {
	    // TODO Auto-generated method stub
	    super.handleMessage(msg);
	}
	
    }
}
