package com.beem.project.beem.ui;

import android.app.ListActivity;
import android.content.ComponentName;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.ServiceConnection;
import android.os.Bundle;
import android.os.IBinder;
import android.os.RemoteException;
import android.widget.ArrayAdapter;
import android.widget.ListView;

import com.beem.project.beem.BeemService;
import com.beem.project.beem.R;
import com.beem.project.beem.service.Contact;
import com.beem.project.beem.service.aidl.IRoster;
import com.beem.project.beem.service.aidl.IXmppFacade;
import com.beem.project.beem.utils.BeemBroadcastReceiver;

/**
 * @author nikita
 *
 */
public class GroupList extends ListActivity {

    private static final Intent SERVICE_INTENT = new Intent();

    private final ServiceConnection mServConn = new BeemServiceConnection();
    private BeemBroadcastReceiver mReceiver;
    private IXmppFacade mXmppFacade;
    private IRoster mRoster;
    private String mJID;
    private ArrayAdapter<String> mGroups;

    private Contact mContact;

    static {
	SERVICE_INTENT.setComponent(new ComponentName("com.beem.project.beem", "com.beem.project.beem.BeemService"));
    }


    @Override
    public void onCreate(Bundle savedInstanceState) {
	super.onCreate(savedInstanceState);
	setContentView(R.layout.group_list);
	mReceiver = new BeemBroadcastReceiver(mServConn);
	mJID = getIntent().getStringExtra("JID");
	final ListView listView = getListView();

	listView.setItemsCanFocus(false);
	listView.setChoiceMode(ListView.CHOICE_MODE_MULTIPLE);
    }

    private void setAdapter(){
	try {
	    mGroups = new ArrayAdapter<String>(this,
		android.R.layout.simple_list_item_multiple_choice, mRoster.getGroupsNames().toArray(new String[(mRoster.getGroupsNames().size())]));
	    setListAdapter(mGroups);
	    mContact = new Contact(mJID);
	    for (String group : mContact.getGroups()) {
		getListView().setItemChecked(mGroups.getPosition(group), true);
	    }
	} catch (RemoteException e) {
	    e.printStackTrace();
	}	
    }

    /**
     * {@inheritDoc}
     */
    @Override
    protected void onResume() {
	super.onResume();
	this.registerReceiver(mReceiver, new IntentFilter(BeemBroadcastReceiver.BEEM_CONNECTION_CLOSED));
	bindService(new Intent(this, BeemService.class), mServConn, BIND_AUTO_CREATE);
	mReceiver.setBinded();
    }

    /**
     * {@inheritDoc}
     */
    @Override
    protected void onPause() {
	super.onPause();
	this.unregisterReceiver(mReceiver);
	if (mReceiver.isBinded())
	    unbindService(mServConn);
    }

    /**
     * The ServiceConnection used to connect to the Beem service.
     */
    private class BeemServiceConnection implements ServiceConnection {

	/**
	 * Constructor.
	 */
	public BeemServiceConnection() { }

	@Override
	public void onServiceConnected(ComponentName name, IBinder service) {
	    mXmppFacade = IXmppFacade.Stub.asInterface(service);
	    try {
		mRoster = mXmppFacade.getRoster();
		setAdapter();
	    } catch (RemoteException e) {
		e.printStackTrace();
	    }
	}

	@Override
	public void onServiceDisconnected(ComponentName name) {
	    mXmppFacade = null;
	    mRoster = null;
	}
    }

}
