/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smack;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.jivesoftware.smack.Connection;
import org.jivesoftware.smack.PacketCollector;
import org.jivesoftware.smack.SmackConfiguration;
import org.jivesoftware.smack.XMPPException;
import org.jivesoftware.smack.filter.AndFilter;
import org.jivesoftware.smack.filter.PacketIDFilter;
import org.jivesoftware.smack.filter.PacketTypeFilter;
import org.jivesoftware.smack.packet.IQ;
import org.jivesoftware.smack.packet.Registration;
import org.jivesoftware.smack.util.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AccountManager {
    private Connection connection;
    private Registration info = null;
    private boolean accountCreationSupported = false;

    public AccountManager(Connection connection) {
        this.connection = connection;
    }

    void setSupportsAccountCreation(boolean bl) {
        this.accountCreationSupported = bl;
    }

    public boolean supportsAccountCreation() {
        if (this.accountCreationSupported) {
            return true;
        }
        try {
            if (this.info == null) {
                this.getRegistrationInfo();
                this.accountCreationSupported = this.info.getType() != IQ.Type.ERROR;
            }
            return this.accountCreationSupported;
        }
        catch (XMPPException xMPPException) {
            return false;
        }
    }

    public Collection<String> getAccountAttributes() {
        try {
            Map<String, String> map;
            if (this.info == null) {
                this.getRegistrationInfo();
            }
            if ((map = this.info.getAttributes()) != null) {
                return Collections.unmodifiableSet(map.keySet());
            }
        }
        catch (XMPPException xMPPException) {
            xMPPException.printStackTrace();
        }
        return Collections.emptySet();
    }

    public String getAccountAttribute(String string) {
        try {
            if (this.info == null) {
                this.getRegistrationInfo();
            }
            return this.info.getAttributes().get(string);
        }
        catch (XMPPException xMPPException) {
            xMPPException.printStackTrace();
            return null;
        }
    }

    public String getAccountInstructions() {
        try {
            if (this.info == null) {
                this.getRegistrationInfo();
            }
            return this.info.getInstructions();
        }
        catch (XMPPException xMPPException) {
            return null;
        }
    }

    public void createAccount(String string, String string2) throws XMPPException {
        if (!this.supportsAccountCreation()) {
            throw new XMPPException("Server does not support account creation.");
        }
        HashMap<String, String> hashMap = new HashMap<String, String>();
        for (String string3 : this.getAccountAttributes()) {
            hashMap.put(string3, "");
        }
        this.createAccount(string, string2, hashMap);
    }

    public void createAccount(String string, String string2, Map<String, String> map) throws XMPPException {
        if (!this.supportsAccountCreation()) {
            throw new XMPPException("Server does not support account creation.");
        }
        Registration registration = new Registration();
        registration.setType(IQ.Type.SET);
        registration.setTo(this.connection.getServiceName());
        map.put("username", string);
        map.put("password", string2);
        registration.setAttributes(map);
        AndFilter andFilter = new AndFilter(new PacketIDFilter(registration.getPacketID()), new PacketTypeFilter(IQ.class));
        PacketCollector packetCollector = this.connection.createPacketCollector(andFilter);
        this.connection.sendPacket(registration);
        IQ iQ = (IQ)packetCollector.nextResult(SmackConfiguration.getPacketReplyTimeout());
        packetCollector.cancel();
        if (iQ == null) {
            throw new XMPPException("No response from server.");
        }
        if (iQ.getType() == IQ.Type.ERROR) {
            throw new XMPPException(iQ.getError());
        }
    }

    public void changePassword(String string) throws XMPPException {
        Registration registration = new Registration();
        registration.setType(IQ.Type.SET);
        registration.setTo(this.connection.getServiceName());
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("username", StringUtils.parseName(this.connection.getUser()));
        hashMap.put("password", string);
        registration.setAttributes(hashMap);
        AndFilter andFilter = new AndFilter(new PacketIDFilter(registration.getPacketID()), new PacketTypeFilter(IQ.class));
        PacketCollector packetCollector = this.connection.createPacketCollector(andFilter);
        this.connection.sendPacket(registration);
        IQ iQ = (IQ)packetCollector.nextResult(SmackConfiguration.getPacketReplyTimeout());
        packetCollector.cancel();
        if (iQ == null) {
            throw new XMPPException("No response from server.");
        }
        if (iQ.getType() == IQ.Type.ERROR) {
            throw new XMPPException(iQ.getError());
        }
    }

    public void deleteAccount() throws XMPPException {
        if (!this.connection.isAuthenticated()) {
            throw new IllegalStateException("Must be logged in to delete a account.");
        }
        Registration registration = new Registration();
        registration.setType(IQ.Type.SET);
        registration.setTo(this.connection.getServiceName());
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("remove", "");
        registration.setAttributes(hashMap);
        AndFilter andFilter = new AndFilter(new PacketIDFilter(registration.getPacketID()), new PacketTypeFilter(IQ.class));
        PacketCollector packetCollector = this.connection.createPacketCollector(andFilter);
        this.connection.sendPacket(registration);
        IQ iQ = (IQ)packetCollector.nextResult(SmackConfiguration.getPacketReplyTimeout());
        packetCollector.cancel();
        if (iQ == null) {
            throw new XMPPException("No response from server.");
        }
        if (iQ.getType() == IQ.Type.ERROR) {
            throw new XMPPException(iQ.getError());
        }
    }

    private synchronized void getRegistrationInfo() throws XMPPException {
        Registration registration = new Registration();
        registration.setTo(this.connection.getServiceName());
        AndFilter andFilter = new AndFilter(new PacketIDFilter(registration.getPacketID()), new PacketTypeFilter(IQ.class));
        PacketCollector packetCollector = this.connection.createPacketCollector(andFilter);
        this.connection.sendPacket(registration);
        IQ iQ = (IQ)packetCollector.nextResult(SmackConfiguration.getPacketReplyTimeout());
        packetCollector.cancel();
        if (iQ == null) {
            throw new XMPPException("No response from server.");
        }
        if (iQ.getType() == IQ.Type.ERROR) {
            throw new XMPPException(iQ.getError());
        }
        this.info = (Registration)iQ;
    }
}

