/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.jivesoftware.smack.packet.Packet;
import org.jivesoftware.smack.packet.PacketExtension;
import org.jivesoftware.smackx.FormField;
import org.jivesoftware.smackx.packet.DataForm;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReportedData {
    private List<Column> columns = new ArrayList<Column>();
    private List<Row> rows = new ArrayList<Row>();
    private String title = "";

    public static ReportedData getReportedDataFrom(Packet packet) {
        DataForm dataForm;
        PacketExtension packetExtension = packet.getExtension("x", "jabber:x:data");
        if (packetExtension != null && (dataForm = (DataForm)packetExtension).getReportedData() != null) {
            return new ReportedData(dataForm);
        }
        return null;
    }

    private ReportedData(DataForm dataForm) {
        Object object;
        Iterator<Object> iterator = dataForm.getReportedData().getFields();
        while (iterator.hasNext()) {
            object = iterator.next();
            this.columns.add(new Column(((FormField)object).getLabel(), ((FormField)object).getVariable(), ((FormField)object).getType()));
        }
        iterator = dataForm.getItems();
        while (iterator.hasNext()) {
            object = (DataForm.Item)iterator.next();
            ArrayList<Field> arrayList = new ArrayList<Field>(this.columns.size());
            Iterator<FormField> iterator2 = ((DataForm.Item)object).getFields();
            while (iterator2.hasNext()) {
                FormField formField = iterator2.next();
                ArrayList<String> arrayList2 = new ArrayList<String>();
                Iterator<String> iterator3 = formField.getValues();
                while (iterator3.hasNext()) {
                    arrayList2.add(iterator3.next());
                }
                arrayList.add(new Field(formField.getVariable(), arrayList2));
            }
            this.rows.add(new Row(arrayList));
        }
        this.title = dataForm.getTitle();
    }

    public ReportedData() {
    }

    public void addRow(Row row) {
        this.rows.add(row);
    }

    public void addColumn(Column column) {
        this.columns.add(column);
    }

    public Iterator<Row> getRows() {
        return Collections.unmodifiableList(new ArrayList<Row>(this.rows)).iterator();
    }

    public Iterator<Column> getColumns() {
        return Collections.unmodifiableList(new ArrayList<Column>(this.columns)).iterator();
    }

    public String getTitle() {
        return this.title;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Field {
        private String variable;
        private List<String> values;

        public Field(String string, List<String> list) {
            this.variable = string;
            this.values = list;
        }

        public String getVariable() {
            return this.variable;
        }

        public Iterator<String> getValues() {
            return Collections.unmodifiableList(this.values).iterator();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Row {
        private List<Field> fields = new ArrayList<Field>();

        public Row(List<Field> list) {
            this.fields = list;
        }

        public Iterator getValues(String string) {
            Iterator<Field> iterator = this.getFields();
            while (iterator.hasNext()) {
                Field field = iterator.next();
                if (!string.equalsIgnoreCase(field.getVariable())) continue;
                return field.getValues();
            }
            return null;
        }

        private Iterator<Field> getFields() {
            return Collections.unmodifiableList(new ArrayList<Field>(this.fields)).iterator();
        }
    }

    public static class Column {
        private String label;
        private String variable;
        private String type;

        public Column(String string, String string2, String string3) {
            this.label = string;
            this.variable = string2;
            this.type = string3;
        }

        public String getLabel() {
            return this.label;
        }

        public String getType() {
            return this.type;
        }

        public String getVariable() {
            return this.variable;
        }
    }
}

