package org.sipdroid.net.tools;

import jlibrtp.PktBufNode;

public class PktBufNodePool extends ObjectPool {

	private static PktBufNodePool instance = null;
	public static PktBufNodePool getInstance() {
		if(instance == null) {
			instance = new PktBufNodePool(20);
		}
		return instance;
	}
	
	public static void removeInstance() {
		instance = null;
	}
	
	protected PktBufNodePool(int nbObject) {
		super(nbObject);
		for(int i = 0; i < nbObject; ++i) {
			checkIn(create());
		}
	}
	
	@Override
	Object create() {
		return new PktBufNode();
	}

	@Override
	boolean validate(Object o) {
		return true;
	}
	
	public PktBufNode borrowBufNode() {
		return (PktBufNode) super.checkOut();
	}
	
	public void returnBufNode(PktBufNode o) {
		super.checkIn(o);
	}

}
