package org.sipdroid.net.tools;

import java.net.DatagramPacket;

public class DatagramPool extends ObjectPool {

	private static DatagramPool instance = null;
	public static DatagramPool getInstance() {
		if(instance == null) {
			instance = new DatagramPool(20);
		}
		return instance;
	}
	
	public static void removeInstance() {
		instance = null;
	}

	protected DatagramPool(int nbDatagram) {
		super(nbDatagram);
		for(int i = 0; i < nbDatagram; ++i) {
			checkIn(create());
		}
	}

	@Override
	Object create() {
		byte[] rawPkt = new byte[1500];
		DatagramPacket packet = new DatagramPacket(rawPkt, rawPkt.length);
		return packet;
	}

	@Override
	boolean validate(Object o) {		
		return true;
	}

	public DatagramPacket borrowPacket() {
		return (DatagramPacket) super.checkOut();
	}

	public void returnPacket(DatagramPacket packet) {
		super.checkIn(packet);
	}
}
