/**
 * 
 */
package org.sipdroid.media.codecs;

import java.util.LinkedList;

/**
 * @author vadim
 *
 */
public class CodecManager {
	
	public static void load() {
		GSM.load();
		G711.load();
		G722.load();
	}
	
	public static LinkedList<Codec>  audioCodecs = new LinkedList<Codec>();
	
	public static Codec  getCodecByDisplayName(String cn) {
		
		for (Codec c : audioCodecs) {
			if (c.getInfo().displayName.equals(cn))
				return c;
		}
		
		return null;
	}

	public static Codec  getCodecByRtpName(String cn) {
		
		for (Codec c : audioCodecs) {
			if (c.getInfo().rtpPayloadName.equals(cn))
				return c;
		}
		
		return null;
	}
	
	
	public static void registerAudioCodec(Codec c) {
		audioCodecs.addLast(c);	
	}
}
