package org.sipdroid.media.codecs;

public abstract class Codec {
	
	public abstract class Context {
	};
	
	public abstract Context  initEncoder();
	public abstract Context  initDecoder();
	public abstract void     cleanEncoder(Context ctx);
	public abstract void  	 cleanDecoder(Context ctx);
	

	public abstract int encode(Context ctx, short[] insample, int inoffset, int size, byte[] outdata, int outoffset);
	public abstract int decode(Context ctx, byte[] indata, int inoffset, int size, short[] outsample, int outoffset);
	
	public abstract CodecInfo getInfo();

}
