package com.beem.project.beem.ui;

import android.app.Activity;
import android.content.Intent;
import android.os.Bundle;
import android.os.Handler;
import android.os.RemoteException;
import android.view.View;
import android.view.View.OnClickListener;
import android.widget.ArrayAdapter;
import android.widget.Button;
import android.widget.Spinner;
import android.widget.TextView;

import com.beem.project.beem.BeemApplication;
import com.beem.project.beem.BeemService;
import com.beem.project.beem.R;
import com.beem.project.beem.service.aidl.IXmppFacade;
import com.beem.project.beem.utils.Status;

public class ChangeStatus extends Activity {

    private TextView mTextStatus;
    private Button mOk;
    private Button mClear;
    private Handler mHandler;
    private BeemApplication mBeemApplication;
    private IXmppFacade mService = null;
    private Spinner mSpinner;
    private static final String[] STATUS = { "Available for chat", "Available", "Busy", "Away", "Unavailable",
	"Disconnected" };
    private static final int DISCONNECTED_IDX = 5;
    private static final int AVAILABLE_FOR_CHAT_IDX = 0;
    private static final int AVAILABLE_IDX = 1;
    private static final int BUSY_IDX = 2;
    private static final int AWAY_IDX = 3;
    private static final int UNAVAILABLE_IDX = 4;

    @Override
    protected void onCreate(Bundle savedInstanceState) {
	super.onCreate(savedInstanceState);
	setContentView(R.layout.changestatus);

	// Beem Application specific
	mHandler = new Handler();
	mBeemApplication = BeemApplication.getApplication(this);

	mTextStatus = (TextView) findViewById(R.id.ChangeStatusText);
	mOk = (Button) findViewById(R.id.ChangeStatusOk);
	mClear = (Button) findViewById(R.id.ChangeStatusClear);
	mOk.setOnClickListener(mOnClickOk);
	mClear.setOnClickListener(mOnClickClear);

	mSpinner = (Spinner) findViewById(R.id.ChangeStatusSpinner);
	ArrayAdapter<String> adapter = new ArrayAdapter<String>(this, android.R.layout.simple_spinner_item, STATUS);
	adapter.setDropDownViewResource(android.R.layout.simple_spinner_dropdown_item);
	mSpinner.setAdapter(adapter);
    }

    @Override
    protected void onStart() {
	super.onStart();
	mBeemApplication.startBeemService();
    }

    @Override
    protected void onResume() {
	super.onResume();
	mBeemApplication.callWhenConnectedToServer(mHandler, new Runnable() {
	    @Override
	    public void run() {
		mService = mBeemApplication.getXmppFacade();
	    }
	});
    }
    
    @Override
    protected void onDestroy() {
        super.onDestroy();
        mBeemApplication.unbindBeemService();
    }

    private OnClickListener mOnClickOk = new OnClickListener() {
	public void onClick(View v) {
	    if (v == mOk) {
		String selected = (String) mSpinner.getSelectedItem();
		if (selected != null) {
		    CharSequence msg = mTextStatus.getText();
		    int status = getStatusForService(selected);
		    if (status == Status.CONTACT_STATUS_DISCONNECT) {
			stopService(new Intent(ChangeStatus.this, BeemService.class));
		    } else
			try {
			    mService.changeStatus(status, msg.toString());

			} catch (RemoteException e) {
			    // TODO Auto-generated catch block
			    e.printStackTrace();
			}
		    ChangeStatus.this.finish();
		}
	    } else if (v == mClear) {
		mTextStatus.setText(null);
	    }

	};
    };

    private OnClickListener mOnClickClear = new OnClickListener() {
	public void onClick(View v) {
	    mTextStatus.setText(null);
	};
    };

    private int getStatusForService(String item) {
	int res = Status.CONTACT_STATUS_AVAILABLE;
	for (int i = 0; i < ChangeStatus.STATUS.length; i++) {
	    String str = ChangeStatus.STATUS[i];
	    if (str.equals(item)) {
		switch (i) {
		    case ChangeStatus.DISCONNECTED_IDX:
			return Status.CONTACT_STATUS_DISCONNECT;
		    case ChangeStatus.AVAILABLE_FOR_CHAT_IDX:
			return Status.CONTACT_STATUS_AVAILABLE_FOR_CHAT;
		    case ChangeStatus.AVAILABLE_IDX:
			return Status.CONTACT_STATUS_AVAILABLE;
		    case ChangeStatus.AWAY_IDX:
			return Status.CONTACT_STATUS_AWAY;
		    case ChangeStatus.BUSY_IDX:
			return Status.CONTACT_STATUS_BUSY;
		    case ChangeStatus.UNAVAILABLE_IDX:
			return Status.CONTACT_STATUS_UNAVAILABLE;
		    default:
			res = Status.CONTACT_STATUS_AVAILABLE;
			break;
		}
	    }
	}
	return res;
    }
}
