/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smack;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.lang.reflect.Constructor;
import java.lang.reflect.GenericDeclaration;
import java.lang.reflect.Method;
import java.net.Socket;
import java.net.UnknownHostException;
import java.security.KeyStore;
import java.security.Provider;
import java.security.SecureRandom;
import java.security.Security;
import java.util.Collection;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.atomic.AtomicInteger;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.TrustManager;
import org.apache.harmony.javax.security.auth.callback.Callback;
import org.apache.harmony.javax.security.auth.callback.CallbackHandler;
import org.apache.harmony.javax.security.auth.callback.PasswordCallback;
import org.jivesoftware.smack.AccountManager;
import org.jivesoftware.smack.ChatManager;
import org.jivesoftware.smack.ConnectionConfiguration;
import org.jivesoftware.smack.ConnectionCreationListener;
import org.jivesoftware.smack.ConnectionListener;
import org.jivesoftware.smack.NonSASLAuthentication;
import org.jivesoftware.smack.PacketCollector;
import org.jivesoftware.smack.PacketInterceptor;
import org.jivesoftware.smack.PacketListener;
import org.jivesoftware.smack.PacketReader;
import org.jivesoftware.smack.PacketWriter;
import org.jivesoftware.smack.Roster;
import org.jivesoftware.smack.SASLAuthentication;
import org.jivesoftware.smack.ServerTrustManager;
import org.jivesoftware.smack.SmackConfiguration;
import org.jivesoftware.smack.XMPPException;
import org.jivesoftware.smack.debugger.SmackDebugger;
import org.jivesoftware.smack.filter.PacketFilter;
import org.jivesoftware.smack.packet.Packet;
import org.jivesoftware.smack.packet.Presence;
import org.jivesoftware.smack.packet.XMPPError;
import org.jivesoftware.smack.util.StringUtils;

public class XMPPConnection {
    public static boolean DEBUG_ENABLED = false;
    private static final Set<ConnectionCreationListener> connectionEstablishedListeners = new CopyOnWriteArraySet<ConnectionCreationListener>();
    private static AtomicInteger connectionCounter = new AtomicInteger(0);
    private CallbackHandler callbackHandler = null;
    private SmackDebugger debugger = null;
    String host;
    int port;
    Socket socket;
    String serviceName;
    int connectionCounterValue = connectionCounter.getAndIncrement();
    String connectionID = null;
    private String user = null;
    private boolean connected = false;
    private boolean authenticated = false;
    private boolean wasAuthenticated = false;
    private boolean anonymous = false;
    private boolean usingTLS = false;
    PacketWriter packetWriter;
    PacketReader packetReader;
    Roster roster = null;
    private AccountManager accountManager = null;
    private SASLAuthentication saslAuthentication = new SASLAuthentication(this);
    Writer writer;
    Reader reader;
    private Collection compressionMethods;
    private boolean usingCompression;
    private ConnectionConfiguration configuration;
    private ChatManager chatManager;

    public XMPPConnection(String string, CallbackHandler callbackHandler) {
        ConnectionConfiguration connectionConfiguration = new ConnectionConfiguration(string);
        connectionConfiguration.setCompressionEnabled(false);
        connectionConfiguration.setSASLAuthenticationEnabled(true);
        connectionConfiguration.setDebuggerEnabled(DEBUG_ENABLED);
        this.configuration = connectionConfiguration;
        this.callbackHandler = callbackHandler;
    }

    public XMPPConnection(String string) {
        ConnectionConfiguration connectionConfiguration = new ConnectionConfiguration(string);
        connectionConfiguration.setCompressionEnabled(false);
        connectionConfiguration.setSASLAuthenticationEnabled(true);
        connectionConfiguration.setDebuggerEnabled(DEBUG_ENABLED);
        this.configuration = connectionConfiguration;
        this.callbackHandler = connectionConfiguration.getCallbackHandler();
    }

    public XMPPConnection(ConnectionConfiguration connectionConfiguration) {
        this.configuration = connectionConfiguration;
        this.callbackHandler = connectionConfiguration.getCallbackHandler();
    }

    public XMPPConnection(ConnectionConfiguration connectionConfiguration, CallbackHandler callbackHandler) {
        this.configuration = connectionConfiguration;
        this.callbackHandler = callbackHandler;
    }

    public String getConnectionID() {
        if (!this.isConnected()) {
            return null;
        }
        return this.connectionID;
    }

    public String getServiceName() {
        return this.serviceName;
    }

    public String getHost() {
        return this.host;
    }

    public int getPort() {
        return this.port;
    }

    public String getUser() {
        if (!this.isAuthenticated()) {
            return null;
        }
        return this.user;
    }

    public void login(String string, String string2) throws XMPPException {
        this.login(string, string2, "Smack");
    }

    public synchronized void login(String string, String string2, String string3) throws XMPPException {
        if (!this.isConnected()) {
            throw new IllegalStateException("Not connected to server.");
        }
        if (this.authenticated) {
            throw new IllegalStateException("Already logged in to server.");
        }
        string = string.toLowerCase().trim();
        String string4 = this.configuration.isSASLAuthenticationEnabled() && this.saslAuthentication.hasNonAnonymousAuthentication() ? (string2 != null ? this.saslAuthentication.authenticate(string, string2, string3) : this.saslAuthentication.authenticate(string, string3, this.configuration.getCallbackHandler())) : new NonSASLAuthentication(this).authenticate(string, string2, string3);
        if (string4 != null) {
            this.user = string4;
            this.serviceName = StringUtils.parseServer(string4);
        } else {
            this.user = string + "@" + this.serviceName;
            if (string3 != null) {
                this.user = this.user + "/" + string3;
            }
        }
        if (this.configuration.isCompressionEnabled()) {
            this.useCompression();
        }
        if (this.roster == null) {
            this.roster = new Roster(this);
        }
        if (this.configuration.isRosterLoadedAtLogin()) {
            this.roster.reload();
        }
        if (this.configuration.isSendPresence()) {
            this.packetWriter.sendPacket(new Presence(Presence.Type.available));
        }
        this.authenticated = true;
        this.anonymous = false;
        this.getConfiguration().setLoginInfo(string, string2, string3);
        if (this.configuration.isDebuggerEnabled() && this.debugger != null) {
            this.debugger.userHasLogged(this.user);
        }
    }

    public synchronized void loginAnonymously() throws XMPPException {
        if (!this.isConnected()) {
            throw new IllegalStateException("Not connected to server.");
        }
        if (this.authenticated) {
            throw new IllegalStateException("Already logged in to server.");
        }
        String string = this.configuration.isSASLAuthenticationEnabled() && this.saslAuthentication.hasAnonymousAuthentication() ? this.saslAuthentication.authenticateAnonymously() : new NonSASLAuthentication(this).authenticateAnonymously();
        this.user = string;
        this.serviceName = StringUtils.parseServer(string);
        if (this.configuration.isCompressionEnabled()) {
            this.useCompression();
        }
        this.roster = null;
        this.packetWriter.sendPacket(new Presence(Presence.Type.available));
        this.authenticated = true;
        this.anonymous = true;
        if (this.configuration.isDebuggerEnabled() && this.debugger != null) {
            this.debugger.userHasLogged(this.user);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Roster getRoster() {
        if (!this.configuration.isRosterLoadedAtLogin()) {
            this.roster.reload();
        }
        if (this.roster == null) {
            return null;
        }
        if (!this.roster.rosterInitialized) {
            try {
                Roster roster = this.roster;
                synchronized (roster) {
                    long l;
                    long l2 = System.currentTimeMillis();
                    for (long i = (long)SmackConfiguration.getPacketReplyTimeout(); !this.roster.rosterInitialized && i > 0L; i -= l - l2) {
                        this.roster.wait(i);
                        l = System.currentTimeMillis();
                        l2 = l;
                    }
                }
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        return this.roster;
    }

    public AccountManager getAccountManager() {
        if (this.accountManager == null) {
            this.accountManager = new AccountManager(this);
        }
        return this.accountManager;
    }

    public synchronized ChatManager getChatManager() {
        if (this.chatManager == null) {
            this.chatManager = new ChatManager(this);
        }
        return this.chatManager;
    }

    public boolean isConnected() {
        return this.connected;
    }

    public boolean isSecureConnection() {
        return this.isUsingTLS();
    }

    public boolean isAuthenticated() {
        return this.authenticated;
    }

    public boolean isAnonymous() {
        return this.anonymous;
    }

    protected void shutdown(Presence presence) {
        this.packetWriter.sendPacket(presence);
        this.setWasAuthenticated(this.authenticated);
        this.authenticated = false;
        this.connected = false;
        this.packetReader.shutdown();
        this.packetWriter.shutdown();
        try {
            Thread.sleep(150L);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (this.reader != null) {
            try {
                this.reader.close();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            this.reader = null;
        }
        if (this.writer != null) {
            try {
                this.writer.close();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            this.writer = null;
        }
        try {
            this.socket.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.saslAuthentication.init();
    }

    public void disconnect() {
        this.disconnect(new Presence(Presence.Type.unavailable));
    }

    public void disconnect(Presence presence) {
        if (this.packetReader == null || this.packetWriter == null) {
            return;
        }
        this.shutdown(presence);
        if (this.roster != null) {
            this.roster.cleanup();
            this.roster = null;
        }
        this.wasAuthenticated = false;
        this.packetWriter.cleanup();
        this.packetWriter = null;
        this.packetReader.cleanup();
        this.packetReader = null;
    }

    public void sendPacket(Packet packet) {
        if (!this.isConnected()) {
            throw new IllegalStateException("Not connected to server.");
        }
        if (packet == null) {
            throw new NullPointerException("Packet is null.");
        }
        this.packetWriter.sendPacket(packet);
    }

    public void addPacketListener(PacketListener packetListener, PacketFilter packetFilter) {
        if (!this.isConnected()) {
            throw new IllegalStateException("Not connected to server.");
        }
        this.packetReader.addPacketListener(packetListener, packetFilter);
    }

    public void removePacketListener(PacketListener packetListener) {
        if (this.packetReader != null) {
            this.packetReader.removePacketListener(packetListener);
        }
    }

    public void addPacketWriterListener(PacketListener packetListener, PacketFilter packetFilter) {
        if (!this.isConnected()) {
            throw new IllegalStateException("Not connected to server.");
        }
        this.packetWriter.addPacketListener(packetListener, packetFilter);
    }

    public void removePacketWriterListener(PacketListener packetListener) {
        if (this.packetWriter != null) {
            this.packetWriter.removePacketListener(packetListener);
        }
    }

    public void addPacketWriterInterceptor(PacketInterceptor packetInterceptor, PacketFilter packetFilter) {
        if (!this.isConnected()) {
            throw new IllegalStateException("Not connected to server.");
        }
        this.packetWriter.addPacketInterceptor(packetInterceptor, packetFilter);
    }

    public void removePacketWriterInterceptor(PacketInterceptor packetInterceptor) {
        this.packetWriter.removePacketInterceptor(packetInterceptor);
    }

    public PacketCollector createPacketCollector(PacketFilter packetFilter) {
        return this.packetReader.createPacketCollector(packetFilter);
    }

    public void addConnectionListener(ConnectionListener connectionListener) {
        if (!this.isConnected()) {
            throw new IllegalStateException("Not connected to server.");
        }
        if (connectionListener == null) {
            return;
        }
        if (!this.packetReader.connectionListeners.contains(connectionListener)) {
            this.packetReader.connectionListeners.add(connectionListener);
        }
    }

    public void removeConnectionListener(ConnectionListener connectionListener) {
        if (this.packetReader != null) {
            this.packetReader.connectionListeners.remove(connectionListener);
        }
    }

    public static void addConnectionCreationListener(ConnectionCreationListener connectionCreationListener) {
        connectionEstablishedListeners.add(connectionCreationListener);
    }

    public static void removeConnectionCreationListener(ConnectionCreationListener connectionCreationListener) {
        connectionEstablishedListeners.remove(connectionCreationListener);
    }

    private void connectUsingConfiguration(ConnectionConfiguration connectionConfiguration) throws XMPPException {
        this.host = connectionConfiguration.getHost();
        this.port = connectionConfiguration.getPort();
        try {
            this.socket = connectionConfiguration.getSocketFactory() == null ? new Socket(this.host, this.port) : connectionConfiguration.getSocketFactory().createSocket(this.host, this.port);
        }
        catch (UnknownHostException unknownHostException) {
            String string = "Could not connect to " + this.host + ":" + this.port + ".";
            throw new XMPPException(string, new XMPPError(XMPPError.Condition.remote_server_timeout, string), unknownHostException);
        }
        catch (IOException iOException) {
            String string = "XMPPError connecting to " + this.host + ":" + this.port + ".";
            throw new XMPPException(string, new XMPPError(XMPPError.Condition.remote_server_error, string), iOException);
        }
        this.serviceName = connectionConfiguration.getServiceName();
        this.initConnection();
    }

    private void initConnection() throws XMPPException {
        boolean bl;
        boolean bl2 = bl = this.packetReader == null || this.packetWriter == null;
        if (!bl) {
            this.usingCompression = false;
        }
        this.initReaderAndWriter();
        try {
            if (bl) {
                this.packetWriter = new PacketWriter(this);
                this.packetReader = new PacketReader(this);
                if (this.configuration.isDebuggerEnabled()) {
                    this.packetReader.addPacketListener(this.debugger.getReaderListener(), null);
                    if (this.debugger.getWriterListener() != null) {
                        this.packetWriter.addPacketListener(this.debugger.getWriterListener(), null);
                    }
                }
            } else {
                this.packetWriter.init();
                this.packetReader.init();
            }
            this.packetWriter.startup();
            this.packetReader.startup();
            this.connected = true;
            this.packetWriter.startKeepAliveProcess();
            if (bl) {
                for (ConnectionCreationListener connectionCreationListener : connectionEstablishedListeners) {
                    connectionCreationListener.connectionCreated(this);
                }
            } else {
                this.packetReader.notifyReconnection();
            }
        }
        catch (XMPPException xMPPException) {
            if (this.packetWriter != null) {
                try {
                    this.packetWriter.shutdown();
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                this.packetWriter = null;
            }
            if (this.packetReader != null) {
                try {
                    this.packetReader.shutdown();
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                this.packetReader = null;
            }
            if (this.reader != null) {
                try {
                    this.reader.close();
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                this.reader = null;
            }
            if (this.writer != null) {
                try {
                    this.writer.close();
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                this.writer = null;
            }
            if (this.socket != null) {
                try {
                    this.socket.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                this.socket = null;
            }
            this.setWasAuthenticated(this.authenticated);
            this.authenticated = false;
            this.connected = false;
            throw xMPPException;
        }
    }

    private void initReaderAndWriter() throws XMPPException {
        Object object;
        GenericDeclaration genericDeclaration;
        Object object2;
        try {
            if (!this.usingCompression) {
                this.reader = new BufferedReader(new InputStreamReader(this.socket.getInputStream(), "UTF-8"));
                this.writer = new BufferedWriter(new OutputStreamWriter(this.socket.getOutputStream(), "UTF-8"));
            } else {
                try {
                    object2 = Class.forName("com.jcraft.jzlib.ZOutputStream");
                    genericDeclaration = ((Class)object2).getConstructor(OutputStream.class, Integer.TYPE);
                    object = ((Constructor)genericDeclaration).newInstance(this.socket.getOutputStream(), 9);
                    Method method = ((Class)object2).getMethod("setFlushMode", Integer.TYPE);
                    method.invoke(object, 2);
                    this.writer = new BufferedWriter(new OutputStreamWriter((OutputStream)object, "UTF-8"));
                    Class<?> clazz = Class.forName("com.jcraft.jzlib.ZInputStream");
                    genericDeclaration = clazz.getConstructor(InputStream.class);
                    Object t = ((Constructor)genericDeclaration).newInstance(this.socket.getInputStream());
                    method = clazz.getMethod("setFlushMode", Integer.TYPE);
                    method.invoke(t, 2);
                    this.reader = new BufferedReader(new InputStreamReader((InputStream)t, "UTF-8"));
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    this.reader = new BufferedReader(new InputStreamReader(this.socket.getInputStream(), "UTF-8"));
                    this.writer = new BufferedWriter(new OutputStreamWriter(this.socket.getOutputStream(), "UTF-8"));
                }
            }
        }
        catch (IOException iOException) {
            throw new XMPPException("XMPPError establishing connection with server.", new XMPPError(XMPPError.Condition.remote_server_error, "XMPPError establishing connection with server."), iOException);
        }
        if (this.configuration.isDebuggerEnabled()) {
            if (this.debugger == null) {
                object2 = null;
                try {
                    object2 = System.getProperty("smack.debuggerClass");
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                genericDeclaration = null;
                if (object2 != null) {
                    try {
                        genericDeclaration = Class.forName((String)object2);
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                }
                if (genericDeclaration == null) {
                    try {
                        genericDeclaration = Class.forName("de.measite.smack.AndroidDebugger");
                    }
                    catch (Exception exception) {
                        try {
                            genericDeclaration = Class.forName("org.jivesoftware.smack.debugger.ConsoleDebugger");
                        }
                        catch (Exception exception2) {
                            exception2.printStackTrace();
                        }
                    }
                }
                try {
                    object = ((Class)genericDeclaration).getConstructor(XMPPConnection.class, Writer.class, Reader.class);
                    this.debugger = (SmackDebugger)((Constructor)object).newInstance(this, this.writer, this.reader);
                    this.reader = this.debugger.getReader();
                    this.writer = this.debugger.getWriter();
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    DEBUG_ENABLED = false;
                }
            } else {
                this.reader = this.debugger.newConnectionReader(this.reader);
                this.writer = this.debugger.newConnectionWriter(this.writer);
            }
        }
    }

    public boolean isUsingTLS() {
        return this.usingTLS;
    }

    public SASLAuthentication getSASLAuthentication() {
        return this.saslAuthentication;
    }

    protected ConnectionConfiguration getConfiguration() {
        return this.configuration;
    }

    void startTLSReceived(boolean bl) {
        if (bl && this.configuration.getSecurityMode() == ConnectionConfiguration.SecurityMode.disabled) {
            this.packetReader.notifyConnectionError(new IllegalStateException("TLS required by server but not allowed by connection configuration"));
            return;
        }
        if (this.configuration.getSecurityMode() == ConnectionConfiguration.SecurityMode.disabled) {
            return;
        }
        try {
            this.writer.write("<starttls xmlns=\"urn:ietf:params:xml:ns:xmpp-tls\"/>");
            this.writer.flush();
        }
        catch (IOException iOException) {
            this.packetReader.notifyConnectionError(iOException);
        }
    }

    void proceedTLSReceived() throws Exception {
        Object object;
        SSLContext sSLContext = SSLContext.getInstance("TLS");
        KeyStore keyStore = null;
        KeyManager[] keyManagerArray = null;
        PasswordCallback passwordCallback = null;
        if (this.callbackHandler == null) {
            keyStore = null;
        } else {
            if (this.configuration.getKeystoreType().equals("NONE")) {
                keyStore = null;
                passwordCallback = null;
            } else if (this.configuration.getKeystoreType().equals("PKCS11")) {
                try {
                    object = Class.forName("sun.security.pkcs11.SunPKCS11").getConstructor(InputStream.class);
                    String string = "name = SmartCard\nlibrary = " + this.configuration.getPKCS11Library();
                    ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(string.getBytes());
                    Provider provider = (Provider)((Constructor)object).newInstance(byteArrayInputStream);
                    Security.addProvider(provider);
                    keyStore = KeyStore.getInstance("PKCS11", provider);
                    passwordCallback = new PasswordCallback("PKCS11 Password: ", false);
                    this.callbackHandler.handle(new Callback[]{passwordCallback});
                    keyStore.load(null, passwordCallback.getPassword());
                }
                catch (Exception exception) {
                    keyStore = null;
                    passwordCallback = null;
                }
            } else if (this.configuration.getKeystoreType().equals("Apple")) {
                keyStore = KeyStore.getInstance("KeychainStore", "Apple");
                keyStore.load(null, null);
            } else {
                keyStore = KeyStore.getInstance(this.configuration.getKeystoreType());
                try {
                    passwordCallback = new PasswordCallback("Keystore Password: ", false);
                    this.callbackHandler.handle(new Callback[]{passwordCallback});
                    keyStore.load(new FileInputStream(this.configuration.getKeystorePath()), passwordCallback.getPassword());
                }
                catch (Exception exception) {
                    keyStore = null;
                    passwordCallback = null;
                }
            }
            object = KeyManagerFactory.getInstance("SunX509");
            try {
                if (passwordCallback == null) {
                    ((KeyManagerFactory)object).init(keyStore, null);
                } else {
                    ((KeyManagerFactory)object).init(keyStore, passwordCallback.getPassword());
                    passwordCallback.clearPassword();
                }
                keyManagerArray = ((KeyManagerFactory)object).getKeyManagers();
            }
            catch (NullPointerException nullPointerException) {
                keyManagerArray = null;
            }
        }
        sSLContext.init(keyManagerArray, new TrustManager[]{new ServerTrustManager(this.serviceName, this.configuration)}, new SecureRandom());
        object = this.socket;
        this.socket = sSLContext.getSocketFactory().createSocket((Socket)object, ((Socket)object).getInetAddress().getHostName(), ((Socket)object).getPort(), true);
        this.socket.setSoTimeout(0);
        this.socket.setKeepAlive(true);
        this.initReaderAndWriter();
        ((SSLSocket)this.socket).startHandshake();
        this.usingTLS = true;
        this.packetWriter.setWriter(this.writer);
        this.packetWriter.openStream();
    }

    void setAvailableCompressionMethods(Collection collection) {
        this.compressionMethods = collection;
    }

    private boolean hasAvailableCompressionMethod(String string) {
        return this.compressionMethods != null && this.compressionMethods.contains(string);
    }

    public boolean isUsingCompression() {
        return this.usingCompression;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean useCompression() {
        if (this.authenticated) {
            throw new IllegalStateException("Compression should be negotiated before authentication.");
        }
        try {
            Class.forName("com.jcraft.jzlib.ZOutputStream");
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new IllegalStateException("Cannot use compression. Add smackx.jar to the classpath");
        }
        if (this.hasAvailableCompressionMethod("zlib")) {
            this.requestStreamCompression();
            XMPPConnection xMPPConnection = this;
            synchronized (xMPPConnection) {
                try {
                    this.wait(SmackConfiguration.getPacketReplyTimeout() * 5);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            return this.usingCompression;
        }
        return false;
    }

    private void requestStreamCompression() {
        try {
            this.writer.write("<compress xmlns='http://jabber.org/protocol/compress'>");
            this.writer.write("<method>zlib</method></compress>");
            this.writer.flush();
        }
        catch (IOException iOException) {
            this.packetReader.notifyConnectionError(iOException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void startStreamCompression() throws Exception {
        this.usingCompression = true;
        this.initReaderAndWriter();
        this.packetWriter.setWriter(this.writer);
        this.packetWriter.openStream();
        XMPPConnection xMPPConnection = this;
        synchronized (xMPPConnection) {
            this.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void streamCompressionDenied() {
        XMPPConnection xMPPConnection = this;
        synchronized (xMPPConnection) {
            this.notify();
        }
    }

    public void connect() throws XMPPException {
        this.connectUsingConfiguration(this.configuration);
        if (this.connected && this.wasAuthenticated) {
            try {
                if (this.isAnonymous()) {
                    this.loginAnonymously();
                } else {
                    this.login(this.getConfiguration().getUsername(), this.getConfiguration().getPassword(), this.getConfiguration().getResource());
                }
            }
            catch (XMPPException xMPPException) {
                xMPPException.printStackTrace();
            }
        }
    }

    private void setWasAuthenticated(boolean bl) {
        if (!this.wasAuthenticated) {
            this.wasAuthenticated = bl;
        }
    }

    static {
        try {
            DEBUG_ENABLED = Boolean.getBoolean("smack.debugEnabled");
        }
        catch (Exception exception) {
            // empty catch block
        }
        SmackConfiguration.getVersion();
    }
}

