/*
 * Decompiled with CFR 0.152.
 */
package org.xbill.DNS.security;

import java.io.ByteArrayInputStream;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import org.xbill.DNS.CERTRecord;
import org.xbill.DNS.Name;
import org.xbill.DNS.Options;

public class CERTConverter {
    public static Certificate parseRecord(CERTRecord cERTRecord) {
        int n = cERTRecord.getCertType();
        byte[] byArray = cERTRecord.getCert();
        try {
            Certificate certificate;
            switch (n) {
                case 1: {
                    CertificateFactory certificateFactory = CertificateFactory.getInstance("X.509");
                    ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
                    certificate = certificateFactory.generateCertificate(byteArrayInputStream);
                    break;
                }
                default: {
                    return null;
                }
            }
            return certificate;
        }
        catch (CertificateException certificateException) {
            if (Options.check("verboseexceptions")) {
                System.err.println("Cert parse exception:" + certificateException);
            }
            return null;
        }
    }

    public static CERTRecord buildRecord(Name name, int n, long l, Certificate certificate, int n2, int n3) {
        try {
            if (!(certificate instanceof X509Certificate)) {
                return null;
            }
            int n4 = 1;
            byte[] byArray = certificate.getEncoded();
            return new CERTRecord(name, n, l, n4, n2, n3, byArray);
        }
        catch (CertificateException certificateException) {
            if (Options.check("verboseexceptions")) {
                System.err.println("Cert build exception:" + certificateException);
            }
            return null;
        }
    }

    public static CERTRecord buildRecord(Name name, int n, long l, Certificate certificate) {
        return CERTConverter.buildRecord(name, n, l, certificate, 0, 0);
    }
}

