/*
    BEEM is a videoconference application on the Android Platform.

    Copyright (C) 2009 by Frederic-Charles Barthelery,
                          Jean-Manuel Da Silva,
                          Nikita Kozlov,
                          Philippe Lago,
                          Jean Baptiste Vergely,
                          Vincent Veronis.

    This file is part of BEEM.

    BEEM is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    BEEM is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with BEEM.  If not, see <http://www.gnu.org/licenses/>.

    Please send bug reports with examples or suggestions to
    contact@beem-project.com or http://dev.beem-project.com/

    Epitech, hereby disclaims all copyright interest in the program "Beem"
    written by Frederic-Charles Barthelery,
               Jean-Manuel Da Silva,
               Nikita Kozlov,
               Philippe Lago,
               Jean Baptiste Vergely,
               Vincent Veronis.

    Nicolas Sadirac, November 26, 2009
    President of Epitech.

    Flavien Astraud, November 26, 2009
    Head of the EIP Laboratory.

 */
package com.beem.project.beem.ui;

import java.util.regex.Pattern;

import android.accounts.Account;
import android.accounts.AccountManager;
import android.app.Activity;
import android.content.Intent;
import android.os.Bundle;
import android.util.Log;
import android.view.View;
import android.view.View.OnClickListener;
import android.widget.Button;
import android.widget.CheckBox;
import android.widget.EditText;
import android.widget.Toast;

import com.beem.project.beem.BeemApplication;
import com.beem.project.beem.BeemIntent;
import com.beem.project.beem.BeemService;
import com.beem.project.beem.R;
import com.beem.project.beem.ui.wizard.AccountConfigure;

/**
 * This activity is used to add a contact.
 * @author nikita
 */
public class AddMuc extends Activity {

    private static final String TAG = "AddContact";
    private final OkListener mOkListener = new OkListener();
    private String mAccount = null;

    /**
     * Constructor.
     */
    public AddMuc() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    protected void onCreate(Bundle savedInstanceState) {
	super.onCreate(savedInstanceState);
	setContentView(R.layout.addmuc);

	Button ok = (Button) findViewById(R.id.addm_ok);
	ok.setOnClickListener(mOkListener);

    }

    @Override
    protected void onResume() {
	super.onResume();

	Bundle b = getIntent().getExtras();
	if (b != null && b.containsKey(BeemIntent.EXTRA_ACCOUNT))
	    mAccount = b.getString(BeemIntent.EXTRA_ACCOUNT);
	else {
	    AccountManager am = AccountManager.get(AddMuc.this);
	    Account allAccount[] = am.getAccountsByType(BeemApplication.BEEM_PACKAGE);
	    Log.e(TAG, "NB ACCOUNT :" + allAccount.length);
	    if (allAccount.length == 0) {
		//TODO: Add toast to advice need to configure at least 1 beem account
		startActivity(new Intent(AddMuc.this, AccountConfigure.class));
	    } else if (allAccount.length == 1) {
		//TODO: Add toast to advice we are adding contact to the account : mAccount
		mAccount = allAccount[0].name;
	    } else if (allAccount.length > 1)
		;// TODO : if multi account propose select
	}
    }

    /**
     * Get the text of a widget.
     * @param id the id of the widget.
     * @return the text of the widget.
     */
    private String getWidgetText(int id) {
	EditText widget = (EditText) this.findViewById(id);
	return widget.getText().toString();
    }

    /**
     * Listener.
     */
    private class OkListener implements OnClickListener {

	/**
	 * Constructor.
	 */
	public OkListener() {
	}

	@Override
	public void onClick(View v) {
	    Log.e(TAG, "Account : " + mAccount);
	    String mucJid = getWidgetText(R.id.addm_jid);
	    Bundle b = new Bundle();
	    b.putString(BeemApplication.MUC_NAME, getWidgetText(R.id.addm_name));
	    b.putString(BeemApplication.MUC_NICKNAME, getWidgetText(R.id.addm_nickname));
	    b.putString(BeemApplication.MUC_PASSWORD, getWidgetText(R.id.addm_password));
	    CheckBox checkboxWidget = (CheckBox) findViewById(R.id.addm_autojoin);
	    b.putBoolean(BeemApplication.MUC_AUTOJOIN, checkboxWidget.isChecked());

	    Intent intent = new Intent(BeemIntent.ACTION_ADD_MUC);
	    intent.putExtra(BeemIntent.EXTRA_ACCOUNT, mAccount);
	    intent.putExtra(BeemIntent.EXTRA_JID, mucJid);
	    intent.putExtra(BeemIntent.EXTRA_MESSAGE, b);
	    startService(intent);

	}
    };
}
