/**
 * 
 */
package com.beem.project.beem.ui;

import android.app.Dialog;
import android.content.Context;
import android.os.RemoteException;
import android.util.Log;
import android.view.View;
import android.widget.Button;
import android.widget.EditText;

import com.beem.project.beem.R;
import com.beem.project.beem.service.Contact;
import com.beem.project.beem.service.aidl.IXmppFacade;

/**
 * @author marseille
 */
public class ContactDialogAliasDialog extends Dialog {

	protected static final String TAG = "CAlias";
	//private String      mName;
	private Contact     mContact;
	private IXmppFacade mService;

	public ContactDialogAliasDialog(Context context, Contact contact) {
		super(context);
		setContentView(R.layout.contactdialogaliasdialog);
		setTitle("Alias");
		mContact = contact;
		EditText nameText = (EditText) findViewById(R.id.CDAliasDialogName);
		nameText.setText(mContact.getName());

		Button ok = (Button) findViewById(R.id.CDAliasDialogOk);
		ok.setOnClickListener(new View.OnClickListener() {

			@Override
			public void onClick(View v) {
				EditText nameText = (EditText) findViewById(R.id.CDAliasDialogName);
				try {
					Log.d(TAG, mContact.getJID() + nameText.getText().toString());
					mService.getRoster().setContactName(mContact.getJID(), nameText.getText().toString());
				} catch (RemoteException e) {
					e.printStackTrace();
				}
				dismiss();
			}

		});
	}

	public void initService(IXmppFacade service) {
		mService = service;
	}
}
