/**
 * 
 */
package com.beem.project.beem.ui;

import java.util.HashMap;
import java.util.Map;

import org.jivesoftware.smack.AccountManager;
import org.jivesoftware.smack.ConnectionConfiguration;
import org.jivesoftware.smack.XMPPConnection;
import org.jivesoftware.smack.XMPPException;

import com.beem.project.beem.R;

import android.app.Activity;
import android.content.SharedPreferences;
import android.os.Bundle;
import android.util.Log;
import android.view.View;
import android.view.View.OnClickListener;
import android.widget.Button;
import android.widget.EditText;
import android.widget.Toast;

/**
 * @author nikita
 *
 */
public class AccountCreation extends Activity {    

    protected static final String TAG = "AccountCreation";
    private SharedPreferences mSettings;
    Map<String, String> mAttributes = new HashMap<String, String>();

    @Override
    protected void onCreate(Bundle savedInstanceState) {
	super.onCreate(savedInstanceState);
	setContentView(R.layout.accountcreation);
	Button ok = (Button) findViewById(R.id.ok);
	mSettings = getSharedPreferences(
		getString(R.string.PreferenceFileName), MODE_PRIVATE);
	ok.setOnClickListener(mOkListener);
    }

    private OnClickListener mOkListener = new OnClickListener() {
	
	@Override
	public void onClick(View v) {
	    boolean valid = true;
	    if (getWidgetText(R.id.login).length() == 0) {
		Log.d(TAG, "login pas ok");
		valid = false;
	    } else {
		mAttributes.put("login", getWidgetText(R.id.login));
		mAttributes.put("name", getWidgetText(R.id.login));
	    }
	    if (getWidgetText(R.id.password).length() == 0 || !getWidgetText(R.id.password).contains(getWidgetText(R.id.password2))) {
		valid = false;
		
	    } else {
		mAttributes.put("password", getWidgetText(R.id.password));
	    }
	    if (getWidgetText(R.id.email).length() == 0) {
		valid = false;
	    } else {
		mAttributes.put("email", getWidgetText(R.id.email));
	    }
	    
	    if (valid) {
		setResult(RESULT_OK);
		try {
		    createAccount();
		    Toast.makeText(AccountCreation.this, "Account created",
	                    Toast.LENGTH_SHORT).show();
		    finish();
		} catch (XMPPException e) {
		    Log.e(TAG, "Account creation failed", e);
		    Toast.makeText(AccountCreation.this, e.getMessage(),
	                    Toast.LENGTH_SHORT).show();
		    e.printStackTrace();
		}
	    } else {
		Toast.makeText(AccountCreation.this, "Form error",
                    Toast.LENGTH_SHORT).show();
		setResult(RESULT_CANCELED);
	    }
	    
	}
    };

    protected void createAccount() throws XMPPException {
	String mHost = mSettings.getString(getString(R.string.PreferenceHostKey), "");
	XMPPConnection xmmpCo = new XMPPConnection(new ConnectionConfiguration(mHost));
	xmmpCo.connect();
	AccountManager accM = new AccountManager(xmmpCo);
	accM.createAccount(mAttributes.get("login"), mAttributes.get("password"), mAttributes);
	xmmpCo.disconnect();
	SharedPreferences.Editor editor = mSettings.edit();
	
	editor.putString(getString(R.string.PreferenceLoginKey), mAttributes.get("login"));
	editor.putString(getString(R.string.PreferencePasswordKey), mAttributes.get("password"));
	editor.commit();	
    }
    
    private String getWidgetText(int id) {
	EditText widget = (EditText) this.findViewById(id);
	return widget.getText().toString();
    }
}