/**
 * 
 */
package com.beem.project.beem.service;

import java.util.ArrayList;
import java.util.List;

import org.jivesoftware.smack.packet.Presence;
import org.jivesoftware.smack.packet.Presence.Mode;

import android.os.Parcel;
import android.os.Parcelable;
import android.util.Log;

/**
 * This class contains informations on a jabber contact.
 * @author darisk
 */
public class Contact implements Parcelable {

    /**
     * Status of a disconnected contact.
     */
    public static final int CONTACT_STATUS_DISCONNECT = 100;

    /**
     * Status of a unavailable (long away) contact.
     */
    public static final int CONTACT_STATUS_UNAVAILABLE = 200;

    /**
     * Status of a away contact.
     */
    public static final int CONTACT_STATUS_AWAY = 300;

    /**
     * Status of a busy contact.
     */
    public static final int CONTACT_STATUS_BUSY = 400;

    /**
     * Status of a available contact.
     */
    public static final int CONTACT_STATUS_AVAILABLE = 500;

    /**
     * Status of a available for chat contact.
     */
    public static final int CONTACT_STATUS_AVAILABLE_FOR_CHAT = 600;

    private static final String TAG = "Contact";

    private int mID;
    private int mStatus;
    private String mJID;
    private String mMsgState;
    private List<String> mRes;

    /**
     * Parcelable.Creator needs by Android.
     */
    public static final Parcelable.Creator<Contact> CREATOR = new Parcelable.Creator<Contact>() {

	@Override
	public Contact createFromParcel(Parcel source) {
	    return new Contact(source);
	}

	@Override
	public Contact[] newArray(int size) {
	    return new Contact[size];
	}
    };

    /**
     * Constructor.
     */
    public Contact() {
	// TODO Auto-generated constructor stub
    }

    /**
     * Constructor.
     * @param jid JID of the contact
     */
    public Contact(final String jid) {
	mJID = jid;
	mStatus = Contact.CONTACT_STATUS_DISCONNECT;
	mRes = new ArrayList<String>();
	mRes.add("none");
    }

    /**
     * Construct a contact from a parcel.
     * @param in parcel to use for construction
     */
    private Contact(final Parcel in) {
	mID = in.readInt();
	mStatus = in.readInt();
	mJID = in.readString();
	mMsgState = in.readString();
	mRes = new ArrayList<String>();
	in.readStringList(mRes);
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public void writeToParcel(Parcel dest, int flags) {
	dest.writeInt(mID);
	dest.writeInt(mStatus);
	dest.writeString(mJID);
	dest.writeString(mMsgState);
	dest.writeStringList(getMRes());
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public int describeContents() {
	// TODO Auto-generated method stub
	return 0;
    }

    /**
     * Get the id of the contact on the phone contact list.
     * @return the mID
     */
    public int getID() {
	return mID;
    }

    /**
     * set the id of te contact on the phone contact list.
     * @param mid the mID to set
     */
    public void setID(int mid) {
	mID = mid;
    }

    /**
     * Get the status of the contact.
     * @return the mStatus
     */
    public int getStatus() {
	return mStatus;
    }

    /**
     * Set the status of the contact.
     * @param status the mStatus to set
     */
    public void setStatus(int status) {
	mStatus = status;
    }

    /**
     * Set the status of the contact using a presence packet.
     * @param presence the presence containing status
     */
    public void setStatus(Presence presence) {
	Log.i(TAG,"PRESENCE");
	if (presence.getType().equals(Presence.Type.unavailable)) {
	    Log.d(TAG, "Presence pas dispo");
	    mStatus = Contact.CONTACT_STATUS_DISCONNECT;
	} else {
	    Log.d(TAG, "Presence OK");
	    Mode mode = presence.getMode();
	    if (mode == null) {
		mStatus = Contact.CONTACT_STATUS_AVAILABLE;
	    }
	    else {
		switch (mode) {
		    case available:
			Log.d(TAG, "Available");
			mStatus = Contact.CONTACT_STATUS_AVAILABLE;
			break;
		    case away:
			Log.d(TAG, "Away");
			mStatus = Contact.CONTACT_STATUS_AWAY;
			break;
		    case chat:
			Log.d(TAG, "Chat");
			mStatus = Contact.CONTACT_STATUS_AVAILABLE_FOR_CHAT;
			break;
		    case dnd:
			Log.d(TAG, "Dnd");
			mStatus = Contact.CONTACT_STATUS_BUSY;
			break;
		    case xa:
			Log.d(TAG, "Xa");
			mStatus = Contact.CONTACT_STATUS_UNAVAILABLE;
			break;
		    default:
			Log.d(TAG, "Status mode non gere");
		    mStatus = Contact.CONTACT_STATUS_DISCONNECT;
		    break;
		}
	    }
	}
    }

    /**
     * Get the message status of the contact.
     * @return the message status of the contact.
     */
    public String getMsgState() {
	return mMsgState;
    }

    /**
     * Set the message status of the contact.
     * @param msgState the message status of the contact to set
     */
    public void setMsgState(String msgState) {
	mMsgState = msgState;
    }

    /**
     * Get the Jabber ID of the contact.
     * @return the Jabber ID
     */
    public String getJID() {
	return mJID;
    }

    /**
     * Set the Jabber ID of the contact.
     * @param mjid the jabber ID to set
     */
    public void setJID(String mjid) {
	mJID = mjid;
    }

    /**
     * 
     * @param res
     */
    public void addRes(String res) {
	if (!mRes.contains(res))
	    mRes.add(res);
    }

    /**
     * 
     * @param res
     */
    public void delRes(String res) {
	mRes.remove(res);
    }

    /**
     * @param mRes the mRes to set
     */
    public void setMRes(List<String> mRes) {
	this.mRes = mRes;
    }

    /**
     * @return the mRes
     */
    public List<String> getMRes() {
	return mRes;
    }
}
