/*
 * Decompiled with CFR 0.152.
 */
package org.jlibrtp.jlibrtp.core;

import java.net.InetSocketAddress;
import org.jlibrtp.jlibrtp.core.Participant;
import org.jlibrtp.jlibrtp.core.ParticipantDatabase;
import org.jlibrtp.jlibrtp.core.RTPSession;
import org.jlibrtp.jlibrtp.core.RtcpPkt;
import org.jlibrtp.jlibrtp.core.StaticProcs;

public class RtcpPktSDES
extends RtcpPkt {
    boolean reportSelf = true;
    RTPSession rtpSession = null;
    protected Participant[] participants = null;

    protected RtcpPktSDES(boolean reportThisSession, RTPSession rtpSession, Participant[] additionalParticipants) {
        this.packetType = 202;
        this.reportSelf = reportThisSession;
        this.participants = additionalParticipants;
        this.rtpSession = rtpSession;
    }

    protected RtcpPktSDES(byte[] aRawPkt, int start, InetSocketAddress socket, ParticipantDatabase partDb) {
        this.rawPkt = aRawPkt;
        if (!super.parseHeaders(start) || this.packetType != 202) {
            this.problem = -202;
        } else {
            int curPos = 4 + start;
            boolean endReached = false;
            this.participants = new Participant[this.itemCount];
            int i = 0;
            while (i < this.itemCount) {
                boolean newPart;
                long ssrc = StaticProcs.bytesToUIntLong(aRawPkt, curPos);
                Participant part = partDb.getParticipant(ssrc);
                if (part == null) {
                    part = new Participant(socket, socket, ssrc);
                    newPart = true;
                } else {
                    newPart = false;
                }
                curPos += 4;
                while (!endReached && curPos / 4 <= this.length) {
                    byte curType = aRawPkt[curPos];
                    if (curType == 0) {
                        curPos += 4 - curPos % 4;
                        endReached = true;
                        continue;
                    }
                    byte curLength = aRawPkt[curPos + 1];
                    if (curLength > 0) {
                        byte[] item = new byte[curLength];
                        System.arraycopy(aRawPkt, curPos + 2, item, 0, curLength);
                        switch (curType) {
                            case 1: {
                                part.cname = new String(item);
                                break;
                            }
                            case 2: {
                                part.name = new String(item);
                                break;
                            }
                            case 3: {
                                part.email = new String(item);
                                break;
                            }
                            case 4: {
                                part.phone = new String(item);
                                break;
                            }
                            case 5: {
                                part.loc = new String(item);
                                break;
                            }
                            case 6: {
                                part.tool = new String(item);
                                break;
                            }
                            case 7: {
                                part.note = new String(item);
                                break;
                            }
                            case 8: {
                                part.priv = new String(item);
                            }
                        }
                    } else {
                        switch (curType) {
                            case 1: {
                                part.cname = null;
                                break;
                            }
                            case 2: {
                                part.name = null;
                                break;
                            }
                            case 3: {
                                part.email = null;
                                break;
                            }
                            case 4: {
                                part.phone = null;
                                break;
                            }
                            case 5: {
                                part.loc = null;
                                break;
                            }
                            case 6: {
                                part.tool = null;
                                break;
                            }
                            case 7: {
                                part.note = null;
                                break;
                            }
                            case 8: {
                                part.priv = null;
                            }
                        }
                    }
                    curPos = curPos + curLength + 2;
                }
                this.participants[i] = part;
                if (newPart) {
                    partDb.addParticipant(2, part);
                }
                ++i;
            }
        }
    }

    @Override
    protected void encode() {
        byte[] temp = new byte[1450];
        byte[] someBytes = StaticProcs.uIntLongToByteWord(this.rtpSession.ssrc);
        System.arraycopy(someBytes, 0, temp, 4, 4);
        int pos = 8;
        String tmpString = null;
        int i = 1;
        while (i < 9) {
            switch (i) {
                case 1: {
                    tmpString = this.rtpSession.cname;
                    break;
                }
                case 2: {
                    tmpString = this.rtpSession.name;
                    break;
                }
                case 3: {
                    tmpString = this.rtpSession.email;
                    break;
                }
                case 4: {
                    tmpString = this.rtpSession.phone;
                    break;
                }
                case 5: {
                    tmpString = this.rtpSession.loc;
                    break;
                }
                case 6: {
                    tmpString = this.rtpSession.tool;
                    break;
                }
                case 7: {
                    tmpString = this.rtpSession.note;
                    break;
                }
                case 8: {
                    tmpString = this.rtpSession.priv;
                }
            }
            if (tmpString != null) {
                someBytes = tmpString.getBytes();
                temp[pos] = (byte)i;
                temp[pos + 1] = (byte)someBytes.length;
                System.arraycopy(someBytes, 0, temp, pos + 2, someBytes.length);
                pos = pos + someBytes.length + 2;
            }
            ++i;
        }
        int leftover = pos % 4;
        if (leftover == 1) {
            temp[pos] = 0;
            temp[pos + 1] = 1;
            pos += 3;
        } else if (leftover == 2) {
            temp[pos] = 0;
            temp[pos + 1] = 0;
            pos += 2;
        } else if (leftover == 3) {
            temp[pos] = 0;
            temp[pos + 1] = 3;
            pos += 5;
        }
        this.rawPkt = new byte[pos];
        this.itemCount = 1;
        System.arraycopy(temp, 0, this.rawPkt, 0, pos);
        this.writeHeaders();
    }

    public void debugPrint() {
        System.out.println("RtcpPktSDES.debugPrint() ");
        if (this.participants != null) {
            int i = 0;
            while (i < this.participants.length) {
                Participant part = this.participants[i];
                System.out.println("     part.ssrc: " + part.ssrc + "  part.cname: " + part.cname + " part.loc: " + part.loc);
                ++i;
            }
        } else {
            System.out.println("     nothing to report (only valid for received packets)");
        }
    }
}

