package com.beem.project.beem.jingle;

import java.util.ArrayList;
import java.util.List;

import org.jivesoftware.smack.ConnectionConfiguration;
import org.jivesoftware.smack.XMPPConnection;
import org.jivesoftware.smack.XMPPException;
import org.jivesoftware.smackx.jingle.JingleManager;
import org.jivesoftware.smackx.jingle.JingleSession;
import org.jivesoftware.smackx.jingle.JingleSessionRequest;
import org.jivesoftware.smackx.jingle.listeners.JingleSessionListener;
import org.jivesoftware.smackx.jingle.listeners.JingleSessionRequestListener;
import org.jivesoftware.smackx.jingle.media.JingleMediaManager;
import org.jivesoftware.smackx.jingle.media.PayloadType;
import org.jivesoftware.smackx.jingle.nat.BasicTransportManager;
import org.jivesoftware.smackx.jingle.nat.TransportCandidate;


public class Receiver {

	private XMPPConnection con;
	private JingleManager jingleManager;
	private List<JingleMediaManager> mediaManagers;
	private JingleSession in;
	
	public Receiver(String username, String pass) {
//		XMPPConnection.DEBUG_ENABLED = true;
		ConnectionConfiguration conf = new ConnectionConfiguration("localhost");
		conf.setRosterLoadedAtLogin(false);
		con = new XMPPConnection(conf);
		try {
			con.connect();
			con.login(username, pass, "Receiver");
			initialize();

		} catch (XMPPException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
	}
	
	private void initialize()
	{
		mediaManagers = new ArrayList<JingleMediaManager>();
		mediaManagers.add(new SenderMediaManager(new BasicTransportManager()));
		JingleManager.setJingleServiceEnabled();
		jingleManager = new JingleManager(con, mediaManagers);
		jingleManager.addJingleSessionRequestListener(new JingleSessionRequestListener() {
		
			@Override
			public void sessionRequested(JingleSessionRequest request) {
				System.out.println("Jingle Session request from "+request.getFrom());
				try {
					in = request.accept();
					// TODO configure in
					in.addListener(new JingleSessionListener() {
						
						@Override
						public void sessionRedirected(String redirection,
								JingleSession jingleSession) {
							// TODO Auto-generated method stub
					
						}
					
						@Override
						public void sessionMediaReceived(JingleSession jingleSession,
								String participant) {
							// TODO Auto-generated method stub
					
						}
					
						@Override
						public void sessionEstablished(PayloadType pt,
								TransportCandidate remoteCandidate,
								TransportCandidate localCandidate, JingleSession jingleSession) {
							// TODO Auto-generated method stub
							System.out.println("Session established");
						}
					
						@Override
						public void sessionDeclined(String reason, JingleSession jingleSession) {
							// TODO Auto-generated method stub
							System.out.println("Session "+ jingleSession.getResponder() +"declined because "+ reason);
						}
					
						@Override
						public void sessionClosedOnError(XMPPException e,
								JingleSession jingleSession) {
							// TODO Auto-generated method stub
							System.out.println("Session "+ jingleSession.getResponder() + " closed"); 
					
						}
					
						@Override
						public void sessionClosed(String reason, JingleSession jingleSession) {
							// TODO Auto-generated method stub
							System.out.println("Session "+ jingleSession.getResponder() +"closedd because "+ reason);
						}
					});
					in.startIncoming();
				} catch (XMPPException e) {
					// TODO Auto-generated catch block
					e.printStackTrace();
				}
			}
		});
		
	}
	
	/**
	 * @param args
	 * @throws InterruptedException 
	 * @throws InterruptedException 
	 */
	public static void main(String[] args) throws InterruptedException {
		// TODO Auto-generated method stub
		Receiver rec = new Receiver("test2", "test2");
		System.out.println("Receiver initialized");
		
		Thread.sleep(60000);
		
	}

}
