/*
    BEEM is a videoconference application on the Android Platform.

    Copyright (C) 2009 by Frederic-Charles Barthelery,
                          Jean-Manuel Da Silva,
                          Nikita Kozlov,
                          Philippe Lago,
                          Jean Baptiste Vergely,
                          Vincent Veronis.

    This file is part of BEEM.

    BEEM is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    BEEM is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with BEEM.  If not, see <http://www.gnu.org/licenses/>.

    Please send bug reports with examples or suggestions to
    contact@beem-project.com or http://dev.beem-project.com/

    Epitech, hereby disclaims all copyright interest in the program "Beem"
    written by Frederic-Charles Barthelery,
               Jean-Manuel Da Silva,
               Nikita Kozlov,
               Philippe Lago,
               Jean Baptiste Vergely,
               Vincent Veronis.

    Nicolas Sadirac, November 26, 2009
    President of Epitech.

    Flavien Astraud, November 26, 2009
    Head of the EIP Laboratory.

 */
package com.beem.project.beem.ui;

import android.app.Activity;
import android.content.SharedPreferences;
import android.graphics.drawable.LayerDrawable;
import android.net.Uri;
import android.os.Bundle;
import android.preference.PreferenceManager;
import android.util.Log;
import android.view.KeyEvent;
import android.view.View;
import android.view.View.OnKeyListener;
import android.widget.ImageView;
import android.widget.TextView;

import com.beem.project.beem.R;

/**
 * The chat activity for communication with 1 contact.
 * 
 * @author Vincent V. <marseille@beem-project.com>
 */
public class Chat extends Activity implements OnKeyListener {

	private static final String TAG = "Chat";
	private String mjid;

	/**
	 * Constructor.
	 */
	public Chat() {
		super();
	}

	/**
	 * {@inheritDoc}.
	 */
	@Override
	protected void onCreate(Bundle savedBundle) {
		super.onCreate(savedBundle);
		// TODO : get account from jid. if multi account propose select
		// Intent { act=android.intent.action.SENDTO dat=imto://jabber/jid
		// cmp=com.beem.project.beem/.ui.Chat }
		Uri contactURI = getIntent().getData();		
		mjid = contactURI.getPathSegments().get(0);
		
		SharedPreferences settings = PreferenceManager
				.getDefaultSharedPreferences(this);
		boolean isCompact = settings.getBoolean("settings_chat_compact_key",
				false);
		// UI
		if (!isCompact) {
			setNormalView();
		} else {
			setContentView(R.layout.chat_compact);
		}

	}

	private void setNormalView() {
		Log.d(TAG, "Jid : " + mjid);
		setContentView(R.layout.chat);
		TextView ContactNameTextView = (TextView) findViewById(R.id.chat_contact_name);
		ContactNameTextView.setText(mjid);
		TextView ContactStatusMsgTextView = (TextView) findViewById(R.id.chat_contact_status_msg);
		TextView ContactChatStateTextView = (TextView) findViewById(R.id.chat_contact_chat_state);
		ImageView ContactStatusIcon = (ImageView) findViewById(R.id.chat_contact_status_icon);
		LayerDrawable AvatarStatusDrawable = (LayerDrawable) ContactStatusIcon
				.getDrawable();
		AvatarStatusDrawable.setLayerInset(1, 36, 36, 0, 0);

	}

	@Override
	public boolean onKey(View v, int keyCode, KeyEvent event) {
		return false;
	}

}
