package com.beem.project.beem.jingle.demo;

import org.jivesoftware.smack.ConnectionConfiguration;
import org.jivesoftware.smack.XMPPConnection;
import org.jivesoftware.smack.XMPPException;
import org.jivesoftware.smack.util.StringUtils;

import android.app.Activity;
import android.os.Bundle;
import android.view.View;
import android.view.View.OnClickListener;
import android.widget.Button;
import android.widget.EditText;
import android.widget.Toast;

import com.beem.project.beem.R;
import com.beem.project.beem.jingle.JingleService;

/**
 * Activity used to test Jingle call.
 * @author darisk
 */
public class JingleCallActivity extends Activity {

    private XMPPConnection mConnection;
    private ConnectionConfiguration mConf;
    private JingleService mJingle;

    private Button mBtconnect;
    private Button mBtcall;
    private EditText mEdJID;
    private EditText mEdPassword;
    private EditText mEdReceiver;

    /**
     * Constructor.
     */
    public JingleCallActivity() {
    }

    @Override
    protected void onCreate(Bundle savedInstanceState) {
	// TODO Auto-generated method stub
	super.onCreate(savedInstanceState);
	setContentView(R.layout.jingle_call_activity);
	// localhost
	mConf = new ConnectionConfiguration("10.0.2.2", 5222);
	mEdJID = (EditText) findViewById(R.id.jingledemocalljid);
	mEdPassword = (EditText) findViewById(R.id.jingledemocallpassword);
	mEdReceiver = (EditText) findViewById(R.id.jingledemocallreceiver);
	mBtconnect = (Button) findViewById(R.id.jingledemocallconnectbutton);
	mBtconnect.setOnClickListener(new OnClickListener() {

	    @Override
	    public void onClick(View arg0) {
		String jid = mEdJID.getText().toString();
		String login = StringUtils.parseName(jid);
		mConnection = new XMPPConnection(mConf);
		String password = mEdPassword.getText().toString();
		try {
		    mConnection.connect();
	            mConnection.login(login, password);
	            mJingle = new JingleService(mConnection);
	            mJingle.initWhenConntected(mConnection);
	            mBtcall.setEnabled(true);
	            Toast.makeText(JingleCallActivity.this, "Connected", Toast.LENGTH_SHORT);
                } catch (XMPPException e) {
	            // TODO Auto-generated catch block
	            e.printStackTrace();
                }
	    }

	});
	mBtcall = (Button) findViewById(R.id.jingledemocallbutton);
	mBtcall.setOnClickListener(new OnClickListener() {
	    @Override
	    public void onClick(View arg0) {
		String jid = mEdReceiver.getText().toString();
		if (!"".equals(jid)) {
		    mJingle.call(jid);
		    Toast.makeText(JingleCallActivity.this, "Appel en cours", Toast.LENGTH_SHORT);
		} else
		    Toast.makeText(JingleCallActivity.this, "Remplir le champ (JID complet en  toto@tutu.com/truc)",
			    Toast.LENGTH_SHORT);
	    }
	});

    }

}
