package com.beem.project.beem;

import org.jivesoftware.smack.ConnectionConfiguration;
import org.jivesoftware.smack.ConnectionConfiguration.SecurityMode;
import org.jivesoftware.smack.proxy.ProxyInfo;
import org.jivesoftware.smack.proxy.ProxyInfo.ProxyType;
import org.jivesoftware.smack.util.StringUtils;

import com.beem.project.beem.BeemService.BeemServicePreferenceListener;

import android.content.SharedPreferences;

public class BeemConnection {

    private static final int DEFAULT_XMPP_PORT = 5222;

    private String mLogin;
    private String mJid;
    private String mPassword;
    private String mHost;
    private String mService;
    private int mPort;
    private ConnectionConfiguration mConnectionConfiguration;
    private ProxyInfo mProxyInfo;
    private boolean mUseProxy;
    
    private SharedPreferences mSettings;
    private BeemServicePreferenceListener mPreferenceListener;
 
    /**
     * Constructor.
     */
    public BeemConnection(SharedPreferences settings, BeemServicePreferenceListener preferenceListener) {
	mSettings = settings;
	mPreferenceListener = preferenceListener;
	
	mJid = mSettings.getString(BeemApplication.ACCOUNT_USERNAME_KEY, "");
	mLogin = StringUtils.parseName(mJid);
	mPassword = mSettings.getString(BeemApplication.ACCOUNT_PASSWORD_KEY, "");
	mPort = DEFAULT_XMPP_PORT;
	mService = StringUtils.parseServer(mJid);
	mHost = mService;

	if (mSettings.getBoolean("settings_key_specific_server", false)) {
	    mHost = mSettings.getString("settings_key_xmpp_server", "");
	    if ("".equals(mHost))
		mHost = mService;
	    String tmpPort = mSettings.getString("settings_key_xmpp_port", "5222");
	    mPort = ("".equals(tmpPort)) ? DEFAULT_XMPP_PORT : Integer.parseInt(tmpPort);
	}
	if (mSettings.getBoolean(BeemApplication.FULL_JID_LOGIN_KEY, false) || "gmail.com".equals(mService)
	    || "googlemail.com".equals(mService)) {
	    mLogin = mJid;
	}
	initConnectionConfig();
	
	mSettings.registerOnSharedPreferenceChangeListener(mPreferenceListener);
	
    }
    
    /**
     * Initialize the connection.
     */
    private void initConnectionConfig() {
	mUseProxy = mSettings.getBoolean(BeemApplication.PROXY_USE_KEY, false);
	if (mUseProxy) {
	    String stype = mSettings.getString(BeemApplication.PROXY_TYPE_KEY, "HTTP");
	    String phost = mSettings.getString(BeemApplication.PROXY_SERVER_KEY, "");
	    String puser = mSettings.getString(BeemApplication.PROXY_USERNAME_KEY, "");
	    String ppass = mSettings.getString(BeemApplication.PROXY_PASSWORD_KEY, "");
	    int pport = Integer.parseInt(mSettings.getString(BeemApplication.PROXY_PORT_KEY, "1080"));
	    ProxyInfo.ProxyType type = ProxyType.valueOf(stype);
	    mProxyInfo = new ProxyInfo(type, phost, pport, puser, ppass);
	} else {
	    mProxyInfo = ProxyInfo.forNoProxy();
	}
	if (mSettings.getBoolean("settings_key_specific_server", false))
	    mConnectionConfiguration = new ConnectionConfiguration(mHost, mPort, mService, mProxyInfo);
	else
	    mConnectionConfiguration = new ConnectionConfiguration(mService, mProxyInfo);

	if (mSettings.getBoolean("settings_key_xmpp_tls_use", false)
	    || mSettings.getBoolean("settings_key_gmail", false)) {
	    mConnectionConfiguration.setSecurityMode(SecurityMode.required);
	}
	if (mSettings.getBoolean(BeemApplication.SMACK_DEBUG_KEY, false))
	    mConnectionConfiguration.setDebuggerEnabled(true);
	mConnectionConfiguration.setSendPresence(true);
	// maybe not the universal path, but it works on most devices (Samsung Galaxy, Google Nexus One)
	mConnectionConfiguration.setTruststoreType("BKS");
	mConnectionConfiguration.setTruststorePath("/system/etc/security/cacerts.bks");
    }

    protected void finalize() {
	mSettings.unregisterOnSharedPreferenceChangeListener(mPreferenceListener);
    }

    public void setNoPresence() {
	mConnectionConfiguration.setSendPresence(false);
    }
    
    /**
     * @return the login
     */
    public String getLogin() {
        return mLogin;
    }

    /**
     * @param login the login to set
     */
    public void setLogin(String login) {
        this.mLogin = login;
    }

    /**
     * @return the connectionConfiguration
     */
    public ConnectionConfiguration getConnectionConfiguration() {
        return mConnectionConfiguration;
    }

    /**
     * @param connectionConfiguration the connectionConfiguration to set
     */
    public void setConnectionConfiguration(ConnectionConfiguration connectionConfiguration) {
        this.mConnectionConfiguration = connectionConfiguration;
    }

    /**
     * @return the password
     */
    public String getPassword() {
        return mPassword;
    }

    /**
     * @param password the password to set
     */
    public void setPassword(String password) {
        this.mPassword = password;
    }

    /**
     * @return the settings
     */
    public SharedPreferences getSettings() {
        return mSettings;
    }

    /**
     * @param settings the settings to set
     */
    public void setSettings(SharedPreferences settings) {
        this.mSettings = settings;
    }

    /**
     * @return the jid
     */
    public String getJid() {
        return mJid;
    }

    /**
     * @param jid the jid to set
     */
    public void setJid(String jid) {
        this.mJid = jid;
    }

}
