package com.beem.project.beem;

import android.app.Activity;
import android.content.SharedPreferences;
import android.os.Bundle;
import android.view.Menu;
import android.view.MenuInflater;
import android.view.MenuItem;
import android.widget.EditText;

public class Beem extends Activity {
    public static final String jabberSettings = "Beem";
    private SharedPreferences mSettings;
    /** 
     * Called when the activity is first created. */
    @Override
    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.main);

        mSettings = getSharedPreferences(jabberSettings, MODE_PRIVATE);
        showJID();
    }
    

    public boolean onCreateOptionsMenu(Menu menu) {
        super.onCreateOptionsMenu(menu);
        MenuInflater inflater = getMenuInflater();
        inflater.inflate(R.menu.account, menu);
        return true;
    }

    public boolean onOptionsItemSelected(MenuItem item) {
        SettingsDialog Dialog = new SettingsDialog(this, mSettings);
        switch (item.getItemId()) {        
        case R.id.account_edit:
            Dialog.show();
            return true;
        case R.id.account_about:
            return true;
        }
        return false;
    }

    public void showJID() {
        EditText ejid = (EditText) findViewById(R.id.jid);
        String jid = mSettings.getString("login", "") +
            "@" +  mSettings.getString("host", "") ;
        if (jid.length() == 1)
            jid = "Enter Jabber ID / Create New Account";
        ejid.setText(jid);
    }
    

}
