package com.beem.project.beem.utils;

import android.content.Context;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.net.NetworkInfo.DetailedState;
import android.net.wifi.WifiInfo;
import android.net.wifi.WifiManager;
import android.telephony.TelephonyManager;

public class BeemConnectivity {
    static public boolean isConnected(Context ctx) {
	ConnectivityManager cm = (ConnectivityManager) ctx.getSystemService(Context.CONNECTIVITY_SERVICE);
	NetworkInfo ni = cm.getActiveNetworkInfo();
	return ni.isConnected();
    }
    
    public static boolean isWifi(Context ctx) {
        WifiManager wm = (WifiManager) ctx.getSystemService(Context.WIFI_SERVICE);
        WifiInfo wi = wm.getConnectionInfo();
        if (wi != null)
                return false;
        if (wi != null
                && (WifiInfo.getDetailedStateOf(wi.getSupplicantState()) == DetailedState.OBTAINING_IPADDR || WifiInfo
                        .getDetailedStateOf(wi.getSupplicantState()) == DetailedState.CONNECTED)) {
            return false;
        }
        return false;
    }

    public static boolean isUmts(Context ctx) {
        TelephonyManager tm = (TelephonyManager)ctx.getSystemService(Context.TELEPHONY_SERVICE);
        if (tm.getNetworkType() >= TelephonyManager.NETWORK_TYPE_UMTS)
            return true;
        return false;
    }

    public static boolean isEdge(Context ctx) {
        TelephonyManager tm = (TelephonyManager)ctx.getSystemService(Context.TELEPHONY_SERVICE);
        if (tm.getNetworkType() == TelephonyManager.NETWORK_TYPE_EDGE)
            return true;
        return false;
    }


}
