/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.packet;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.jivesoftware.smack.packet.IQ;
import org.jivesoftware.smackx.jingle.JingleActionEnum;
import org.jivesoftware.smackx.packet.JingleContent;
import org.jivesoftware.smackx.packet.JingleContentInfo;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Jingle
extends IQ {
    public static final String NAMESPACE = "urn:xmpp:tmp:jingle";
    public static final String NODENAME = "jingle";
    private String sid;
    private JingleActionEnum action;
    private String initiator;
    private String responder;
    private final List<JingleContent> contents = new ArrayList<JingleContent>();
    private JingleContentInfo contentInfo;

    public Jingle(List<JingleContent> list, JingleContentInfo jingleContentInfo, String string) {
        if (list != null) {
            list.addAll(list);
        }
        this.setContentInfo(jingleContentInfo);
        this.setSid(string);
        this.initiator = null;
        this.responder = null;
        this.action = null;
    }

    public Jingle(JingleContent jingleContent) {
        this.addContent(jingleContent);
        this.initiator = null;
        this.responder = null;
        this.action = JingleActionEnum.UNKNOWN;
        this.setType(IQ.Type.SET);
    }

    public Jingle(JingleContentInfo jingleContentInfo) {
        this.setContentInfo(jingleContentInfo);
        this.initiator = null;
        this.responder = null;
        this.action = JingleActionEnum.UNKNOWN;
        this.setType(IQ.Type.SET);
    }

    public Jingle(JingleActionEnum jingleActionEnum) {
        this(null, null, null);
        this.action = jingleActionEnum;
        this.setType(IQ.Type.SET);
    }

    public Jingle(String string) {
        this(null, null, string);
    }

    public Jingle() {
    }

    public final void setSid(String string) {
        this.sid = string;
    }

    public String getSid() {
        return this.sid;
    }

    public static String getElementName() {
        return NODENAME;
    }

    public static String getNamespace() {
        return NAMESPACE;
    }

    public JingleContentInfo getContentInfo() {
        return this.contentInfo;
    }

    public void setContentInfo(JingleContentInfo jingleContentInfo) {
        this.contentInfo = jingleContentInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Iterator<JingleContent> getContents() {
        List<JingleContent> list = this.contents;
        synchronized (list) {
            return Collections.unmodifiableList(new ArrayList<JingleContent>(this.contents)).iterator();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<JingleContent> getContentsList() {
        List<JingleContent> list = this.contents;
        synchronized (list) {
            return new ArrayList<JingleContent>(this.contents);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addContent(JingleContent jingleContent) {
        if (jingleContent != null) {
            List<JingleContent> list = this.contents;
            synchronized (list) {
                this.contents.add(jingleContent);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addContents(List<JingleContent> list) {
        if (list != null) {
            List<JingleContent> list2 = this.contents;
            synchronized (list2) {
                this.contents.addAll(list);
            }
        }
    }

    public JingleActionEnum getAction() {
        return this.action;
    }

    public void setAction(JingleActionEnum jingleActionEnum) {
        this.action = jingleActionEnum;
    }

    public String getInitiator() {
        return this.initiator;
    }

    public void setInitiator(String string) {
        this.initiator = string;
    }

    public String getResponder() {
        return this.responder;
    }

    public void setResponder(String string) {
        this.responder = string;
    }

    public static int getSessionHash(String string, String string2) {
        int n = 1;
        n = 31 * n + (string2 == null ? 0 : string2.hashCode());
        n = 31 * n + (string == null ? 0 : string.hashCode());
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getChildElementXML() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("<").append(Jingle.getElementName());
        stringBuilder.append(" xmlns=\"").append(Jingle.getNamespace()).append("\"");
        if (this.getInitiator() != null) {
            stringBuilder.append(" initiator=\"").append(this.getInitiator()).append("\"");
        }
        if (this.getResponder() != null) {
            stringBuilder.append(" responder=\"").append(this.getResponder()).append("\"");
        }
        if (this.getAction() != null) {
            stringBuilder.append(" action=\"").append((Object)this.getAction()).append("\"");
        }
        if (this.getSid() != null) {
            stringBuilder.append(" sid=\"").append(this.getSid()).append("\"");
        }
        stringBuilder.append(">");
        List<JingleContent> list = this.contents;
        synchronized (list) {
            for (JingleContent jingleContent : this.contents) {
                stringBuilder.append(jingleContent.toXML());
            }
        }
        if (this.contentInfo != null) {
            stringBuilder.append(this.contentInfo.toXML());
        }
        stringBuilder.append("</").append(Jingle.getElementName()).append(">");
        return stringBuilder.toString();
    }
}

