/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.filetransfer;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.FutureTask;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.jivesoftware.smack.XMPPException;
import org.jivesoftware.smackx.filetransfer.FileTransfer;
import org.jivesoftware.smackx.filetransfer.FileTransferNegotiator;
import org.jivesoftware.smackx.filetransfer.FileTransferRequest;
import org.jivesoftware.smackx.filetransfer.StreamNegotiator;

public class IncomingFileTransfer
extends FileTransfer {
    private FileTransferRequest recieveRequest;
    private InputStream inputStream;

    protected IncomingFileTransfer(FileTransferRequest fileTransferRequest, FileTransferNegotiator fileTransferNegotiator) {
        super(fileTransferRequest.getRequestor(), fileTransferRequest.getStreamID(), fileTransferNegotiator);
        this.recieveRequest = fileTransferRequest;
    }

    public InputStream recieveFile() throws XMPPException {
        if (this.inputStream != null) {
            throw new IllegalStateException("Transfer already negotiated!");
        }
        try {
            this.inputStream = this.negotiateStream();
        }
        catch (XMPPException xMPPException) {
            this.setException(xMPPException);
            throw xMPPException;
        }
        return this.inputStream;
    }

    public void recieveFile(final File file) throws XMPPException {
        if (file != null) {
            if (!file.exists()) {
                try {
                    file.createNewFile();
                }
                catch (IOException iOException) {
                    throw new XMPPException("Could not create file to write too", iOException);
                }
            }
            if (!file.canWrite()) {
                throw new IllegalArgumentException("Cannot write to provided file");
            }
        } else {
            throw new IllegalArgumentException("File cannot be null");
        }
        Thread thread = new Thread(new Runnable(){

            public void run() {
                try {
                    IncomingFileTransfer.this.inputStream = IncomingFileTransfer.this.negotiateStream();
                }
                catch (XMPPException xMPPException) {
                    IncomingFileTransfer.this.handleXMPPException(xMPPException);
                    return;
                }
                FileOutputStream fileOutputStream = null;
                try {
                    fileOutputStream = new FileOutputStream(file);
                    IncomingFileTransfer.this.setStatus(FileTransfer.Status.in_progress);
                    IncomingFileTransfer.this.writeToStream(IncomingFileTransfer.this.inputStream, fileOutputStream);
                }
                catch (XMPPException xMPPException) {
                    IncomingFileTransfer.this.setStatus(FileTransfer.Status.error);
                    IncomingFileTransfer.this.setError(FileTransfer.Error.stream);
                    IncomingFileTransfer.this.setException(xMPPException);
                }
                catch (FileNotFoundException fileNotFoundException) {
                    IncomingFileTransfer.this.setStatus(FileTransfer.Status.error);
                    IncomingFileTransfer.this.setError(FileTransfer.Error.bad_file);
                    IncomingFileTransfer.this.setException(fileNotFoundException);
                }
                if (IncomingFileTransfer.this.getStatus().equals((Object)FileTransfer.Status.in_progress)) {
                    IncomingFileTransfer.this.setStatus(FileTransfer.Status.complete);
                }
                if (IncomingFileTransfer.this.inputStream != null) {
                    try {
                        IncomingFileTransfer.this.inputStream.close();
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                }
                if (fileOutputStream != null) {
                    try {
                        ((OutputStream)fileOutputStream).close();
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                }
            }
        }, "File Transfer " + this.streamID);
        thread.start();
    }

    private void handleXMPPException(XMPPException xMPPException) {
        this.setStatus(FileTransfer.Status.error);
        this.setException(xMPPException);
    }

    private InputStream negotiateStream() throws XMPPException {
        InputStream inputStream;
        this.setStatus(FileTransfer.Status.negotiating_transfer);
        final StreamNegotiator streamNegotiator = this.negotiator.selectStreamNegotiator(this.recieveRequest);
        this.setStatus(FileTransfer.Status.negotiating_stream);
        FutureTask<InputStream> futureTask = new FutureTask<InputStream>(new Callable<InputStream>(){

            @Override
            public InputStream call() throws Exception {
                return streamNegotiator.createIncomingStream(IncomingFileTransfer.this.recieveRequest.getStreamInitiation());
            }
        });
        futureTask.run();
        try {
            inputStream = futureTask.get(15L, TimeUnit.SECONDS);
        }
        catch (InterruptedException interruptedException) {
            throw new XMPPException("Interruption while executing", interruptedException);
        }
        catch (ExecutionException executionException) {
            throw new XMPPException("Error in execution", executionException);
        }
        catch (TimeoutException timeoutException) {
            throw new XMPPException("Request timed out", timeoutException);
        }
        finally {
            futureTask.cancel(true);
        }
        this.setStatus(FileTransfer.Status.negotiated);
        return inputStream;
    }

    public void cancel() {
        this.setStatus(FileTransfer.Status.cancelled);
    }
}

