/*
 * Decompiled with CFR 0.152.
 */
package org.xbill.DNS;

import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.UnknownHostException;
import java.util.Iterator;
import java.util.List;
import org.xbill.DNS.Message;
import org.xbill.DNS.Name;
import org.xbill.DNS.OPTRecord;
import org.xbill.DNS.Options;
import org.xbill.DNS.Rcode;
import org.xbill.DNS.Record;
import org.xbill.DNS.ResolveThread;
import org.xbill.DNS.Resolver;
import org.xbill.DNS.ResolverConfig;
import org.xbill.DNS.ResolverListener;
import org.xbill.DNS.TCPClient;
import org.xbill.DNS.TSIG;
import org.xbill.DNS.UDPClient;
import org.xbill.DNS.WireParseException;
import org.xbill.DNS.ZoneTransferException;
import org.xbill.DNS.ZoneTransferIn;

public class SimpleResolver
implements Resolver {
    public static final int DEFAULT_PORT = 53;
    public static final int DEFAULT_EDNS_PAYLOADSIZE = 1280;
    private InetSocketAddress address;
    private InetSocketAddress localAddress;
    private boolean useTCP;
    private boolean ignoreTruncation;
    private OPTRecord queryOPT;
    private TSIG tsig;
    private long timeoutValue = 10000L;
    private static final short DEFAULT_UDPSIZE = 512;
    private static String defaultResolver = "localhost";
    private static int uniqueID = 0;

    public SimpleResolver(String string) throws UnknownHostException {
        if (string == null && (string = ResolverConfig.getCurrentConfig().server()) == null) {
            string = defaultResolver;
        }
        InetAddress inetAddress = string.equals("0") ? InetAddress.getLocalHost() : InetAddress.getByName(string);
        this.address = new InetSocketAddress(inetAddress, 53);
    }

    public SimpleResolver() throws UnknownHostException {
        this(null);
    }

    InetSocketAddress getAddress() {
        return this.address;
    }

    public static void setDefaultResolver(String string) {
        defaultResolver = string;
    }

    public void setPort(int n) {
        this.address = new InetSocketAddress(this.address.getAddress(), n);
    }

    public void setAddress(InetSocketAddress inetSocketAddress) {
        this.address = inetSocketAddress;
    }

    public void setAddress(InetAddress inetAddress) {
        this.address = new InetSocketAddress(inetAddress, this.address.getPort());
    }

    public void setLocalAddress(InetSocketAddress inetSocketAddress) {
        this.localAddress = inetSocketAddress;
    }

    public void setLocalAddress(InetAddress inetAddress) {
        this.localAddress = new InetSocketAddress(inetAddress, 0);
    }

    public void setTCP(boolean bl) {
        this.useTCP = bl;
    }

    public void setIgnoreTruncation(boolean bl) {
        this.ignoreTruncation = bl;
    }

    public void setEDNS(int n, int n2, int n3, List list) {
        if (n != 0 && n != -1) {
            throw new IllegalArgumentException("invalid EDNS level - must be 0 or -1");
        }
        if (n2 == 0) {
            n2 = 1280;
        }
        this.queryOPT = new OPTRecord(n2, 0, n, n3, list);
    }

    public void setEDNS(int n) {
        this.setEDNS(n, 0, 0, null);
    }

    public void setTSIGKey(TSIG tSIG) {
        this.tsig = tSIG;
    }

    TSIG getTSIGKey() {
        return this.tsig;
    }

    public void setTimeout(int n, int n2) {
        this.timeoutValue = (long)n * 1000L + (long)n2;
    }

    public void setTimeout(int n) {
        this.setTimeout(n, 0);
    }

    long getTimeout() {
        return this.timeoutValue;
    }

    private Message parseMessage(byte[] byArray) throws WireParseException {
        try {
            return new Message(byArray);
        }
        catch (IOException iOException) {
            WireParseException wireParseException;
            if (Options.check("verbose")) {
                iOException.printStackTrace();
            }
            if (!(iOException instanceof WireParseException)) {
                wireParseException = new WireParseException("Error parsing message");
            }
            throw (WireParseException)wireParseException;
        }
    }

    private void verifyTSIG(Message message, Message message2, byte[] byArray, TSIG tSIG) {
        if (tSIG == null) {
            return;
        }
        int n = tSIG.verify(message2, byArray, message.getTSIG());
        if (Options.check("verbose")) {
            System.err.println("TSIG verify: " + Rcode.string(n));
        }
    }

    private void applyEDNS(Message message) {
        if (this.queryOPT == null || message.getOPT() != null) {
            return;
        }
        message.addRecord(this.queryOPT, 3);
    }

    private int maxUDPSize(Message message) {
        OPTRecord oPTRecord = message.getOPT();
        if (oPTRecord == null) {
            return 512;
        }
        return oPTRecord.getPayloadSize();
    }

    public Message send(Message message) throws IOException {
        Object object;
        Object object2;
        if (Options.check("verbose")) {
            System.err.println("Sending to " + this.address.getAddress().getHostAddress() + ":" + this.address.getPort());
        }
        if (message.getHeader().getOpcode() == 0 && (object2 = message.getQuestion()) != null && ((Record)object2).getType() == 252) {
            return this.sendAXFR(message);
        }
        message = (Message)message.clone();
        this.applyEDNS(message);
        if (this.tsig != null) {
            this.tsig.apply(message, null);
        }
        object2 = message.toWire(65535);
        int n = this.maxUDPSize(message);
        boolean bl = false;
        long l = System.currentTimeMillis() + this.timeoutValue;
        while (true) {
            byte[] byArray;
            if (this.useTCP || ((Object)object2).length > n) {
                bl = true;
            }
            if ((byArray = bl ? TCPClient.sendrecv(this.localAddress, this.address, (byte[])object2, l) : UDPClient.sendrecv(this.localAddress, this.address, (byte[])object2, n, l)).length < 12) {
                throw new WireParseException("invalid DNS header - too short");
            }
            int n2 = ((byArray[0] & 0xFF) << 8) + (byArray[1] & 0xFF);
            int n3 = message.getHeader().getID();
            if (n2 != n3) {
                object = "invalid message id: expected " + n3 + "; got id " + n2;
                if (bl) {
                    throw new WireParseException((String)object);
                }
                if (!Options.check("verbose")) continue;
                System.err.println((String)object);
                continue;
            }
            object = this.parseMessage(byArray);
            this.verifyTSIG(message, (Message)object, byArray, this.tsig);
            if (bl || this.ignoreTruncation || !((Message)object).getHeader().getFlag(6)) break;
            bl = true;
        }
        return object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object sendAsync(Message message, ResolverListener resolverListener) {
        Integer n;
        Object object = this;
        synchronized (object) {
            n = new Integer(uniqueID++);
        }
        object = message.getQuestion();
        String string = object != null ? ((Record)object).getName().toString() : "(none)";
        String string2 = this.getClass() + ": " + string;
        ResolveThread resolveThread = new ResolveThread(this, message, n, resolverListener);
        resolveThread.setName(string2);
        resolveThread.setDaemon(true);
        resolveThread.start();
        return n;
    }

    private Message sendAXFR(Message message) throws IOException {
        Name name = message.getQuestion().getName();
        ZoneTransferIn zoneTransferIn = ZoneTransferIn.newAXFR(name, this.address, this.tsig);
        zoneTransferIn.setTimeout((int)(this.getTimeout() / 1000L));
        zoneTransferIn.setLocalAddress(this.localAddress);
        try {
            zoneTransferIn.run();
        }
        catch (ZoneTransferException zoneTransferException) {
            throw new WireParseException(zoneTransferException.getMessage());
        }
        List list = zoneTransferIn.getAXFR();
        Message message2 = new Message(message.getHeader().getID());
        message2.getHeader().setFlag(5);
        message2.getHeader().setFlag(0);
        message2.addRecord(message.getQuestion(), 0);
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            message2.addRecord((Record)iterator.next(), 1);
        }
        return message2;
    }
}

