/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.workgroup.packet;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.TimeZone;
import org.jivesoftware.smack.packet.PacketExtension;
import org.jivesoftware.smack.provider.PacketExtensionProvider;
import org.xmlpull.v1.XmlPullParser;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AgentStatus
implements PacketExtension {
    private static final SimpleDateFormat UTC_FORMAT = new SimpleDateFormat("yyyyMMdd'T'HH:mm:ss");
    public static final String ELEMENT_NAME = "agent-status";
    public static final String NAMESPACE = "http://jabber.org/protocol/workgroup";
    private String workgroupJID;
    private List<ChatInfo> currentChats = new ArrayList<ChatInfo>();
    private int maxChats = -1;

    AgentStatus() {
    }

    public String getWorkgroupJID() {
        return this.workgroupJID;
    }

    public List<ChatInfo> getCurrentChats() {
        return Collections.unmodifiableList(this.currentChats);
    }

    public int getMaxChats() {
        return this.maxChats;
    }

    @Override
    public String getElementName() {
        return ELEMENT_NAME;
    }

    @Override
    public String getNamespace() {
        return NAMESPACE;
    }

    @Override
    public String toXML() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("<").append(ELEMENT_NAME).append(" xmlns=\"").append(NAMESPACE).append("\"");
        if (this.workgroupJID != null) {
            stringBuilder.append(" jid=\"").append(this.workgroupJID).append("\"");
        }
        stringBuilder.append(">");
        if (this.maxChats != -1) {
            stringBuilder.append("<max-chats>").append(this.maxChats).append("</max-chats>");
        }
        if (!this.currentChats.isEmpty()) {
            stringBuilder.append("<current-chats xmlns= \"http://jivesoftware.com/protocol/workgroup\">");
            Iterator<ChatInfo> iterator = this.currentChats.iterator();
            while (iterator.hasNext()) {
                stringBuilder.append(iterator.next().toXML());
            }
            stringBuilder.append("</current-chats>");
        }
        stringBuilder.append("</").append(this.getElementName()).append("> ");
        return stringBuilder.toString();
    }

    static {
        UTC_FORMAT.setTimeZone(TimeZone.getTimeZone("GMT+0"));
    }

    public static class Provider
    implements PacketExtensionProvider {
        public PacketExtension parseExtension(XmlPullParser xmlPullParser) throws Exception {
            AgentStatus agentStatus = new AgentStatus();
            agentStatus.workgroupJID = xmlPullParser.getAttributeValue("", "jid");
            boolean bl = false;
            while (!bl) {
                int n = xmlPullParser.next();
                if (n == 2) {
                    if ("chat".equals(xmlPullParser.getName())) {
                        agentStatus.currentChats.add(this.parseChatInfo(xmlPullParser));
                        continue;
                    }
                    if (!"max-chats".equals(xmlPullParser.getName())) continue;
                    agentStatus.maxChats = Integer.parseInt(xmlPullParser.nextText());
                    continue;
                }
                if (n != 3 || !AgentStatus.ELEMENT_NAME.equals(xmlPullParser.getName())) continue;
                bl = true;
            }
            return agentStatus;
        }

        private ChatInfo parseChatInfo(XmlPullParser xmlPullParser) {
            String string = xmlPullParser.getAttributeValue("", "sessionID");
            String string2 = xmlPullParser.getAttributeValue("", "userID");
            Date date = null;
            try {
                date = UTC_FORMAT.parse(xmlPullParser.getAttributeValue("", "startTime"));
            }
            catch (ParseException parseException) {
                // empty catch block
            }
            String string3 = xmlPullParser.getAttributeValue("", "email");
            String string4 = xmlPullParser.getAttributeValue("", "username");
            String string5 = xmlPullParser.getAttributeValue("", "question");
            return new ChatInfo(string, string2, date, string3, string4, string5);
        }
    }

    public static class ChatInfo {
        private String sessionID;
        private String userID;
        private Date date;
        private String email;
        private String username;
        private String question;

        public ChatInfo(String string, String string2, Date date, String string3, String string4, String string5) {
            this.sessionID = string;
            this.userID = string2;
            this.date = date;
            this.email = string3;
            this.username = string4;
            this.question = string5;
        }

        public String getSessionID() {
            return this.sessionID;
        }

        public String getUserID() {
            return this.userID;
        }

        public Date getDate() {
            return this.date;
        }

        public String getEmail() {
            return this.email;
        }

        public String getUsername() {
            return this.username;
        }

        public String getQuestion() {
            return this.question;
        }

        public String toXML() {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("<chat ");
            if (this.sessionID != null) {
                stringBuilder.append(" sessionID=\"").append(this.sessionID).append("\"");
            }
            if (this.userID != null) {
                stringBuilder.append(" userID=\"").append(this.userID).append("\"");
            }
            if (this.date != null) {
                stringBuilder.append(" startTime=\"").append(UTC_FORMAT.format(this.date)).append("\"");
            }
            if (this.email != null) {
                stringBuilder.append(" email=\"").append(this.email).append("\"");
            }
            if (this.username != null) {
                stringBuilder.append(" username=\"").append(this.username).append("\"");
            }
            if (this.question != null) {
                stringBuilder.append(" question=\"").append(this.question).append("\"");
            }
            stringBuilder.append("/>");
            return stringBuilder.toString();
        }
    }
}

