/*
    BEEM is a videoconference application on the Android Platform.

    Copyright (C) 2009 by Frederic-Charles Barthelery,
                          Jean-Manuel Da Silva,
                          Nikita Kozlov,
                          Philippe Lago,
                          Jean Baptiste Vergely,
                          Vincent Veronis.

    This file is part of BEEM.

    BEEM is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    BEEM is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with BEEM.  If not, see <http://www.gnu.org/licenses/>.

    Please send bug reports with examples or suggestions to
    contact@beem-project.com or http://dev.beem-project.com/
 */
package com.beem.project.beem.ui.dialogs.builders;

import android.app.AlertDialog;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.view.View;
import android.view.animation.AnimationUtils;
import android.widget.ImageButton;
import android.widget.TextView;

import com.beem.project.beem.BeemIntent;
import com.beem.project.beem.R;
import com.beem.project.beem.utils.Status;

/**
 * Create the change chat dialog.
 */
public class ChangeStatus extends AlertDialog.Builder {

    private static final String TAG = "Dialogs.Builders > Status";

    private static final int AVAILABLE_FOR_CHAT_IDX = 0;
    private static final int AVAILABLE_IDX = 1;
    private static final int BUSY_IDX = 2;
    private static final int AWAY_IDX = 3;
    private static final int UNAVAILABLE_IDX = 4;
    private static final int DISCONNECTED_IDX = 5;

    /**
     * Constructor.
     * @param context context activity.
     * @param openedChats A list containing the JID of participants of the opened chats.
     */

    public ChangeStatus(final Context context, final String account, final View v) {
	super(context);

	setTitle(context.getString(R.string.ChangeStatusType));
	final CharSequence[] items = context.getResources().getStringArray(R.array.status_types);	
	
	setItems(items, new DialogInterface.OnClickListener() {
	    public void onClick(DialogInterface dialog, int item) {

		TextView accountStatus = (TextView) v.findViewById(R.id.accountstatus);
		accountStatus.setText(R.string.login_pending);

		ImageButton logo = (ImageButton) v.findViewById(R.id.loginanim_logo_anim);
		logo.startAnimation(AnimationUtils.loadAnimation(context, R.anim.rotate_and_scale));

		Intent intent = new Intent(BeemIntent.ACTION_CHANGE_STATUS);
		intent.putExtra(BeemIntent.EXTRA_ACCOUNT, account);
		intent.putExtra(BeemIntent.EXTRA_MESSAGE, getStatusForService(item));
		context.startService(intent);
	    }
	});
    }

    /**
     * convert status text to.
     * @param item selected item text.
     * @return item position in the array.
     */
    private int getStatusForService(int item) {
	int result;

	switch (item) {
	    case ChangeStatus.DISCONNECTED_IDX:
		result = Status.CONTACT_STATUS_DISCONNECT;
		break;
	    case ChangeStatus.AVAILABLE_FOR_CHAT_IDX:
		result = Status.CONTACT_STATUS_AVAILABLE_FOR_CHAT;
		break;
	    case ChangeStatus.AVAILABLE_IDX:
		result = Status.CONTACT_STATUS_AVAILABLE;
		break;
	    case ChangeStatus.AWAY_IDX:
		result = Status.CONTACT_STATUS_AWAY;
		break;
	    case ChangeStatus.BUSY_IDX:
		result = Status.CONTACT_STATUS_BUSY;
		break;
	    case ChangeStatus.UNAVAILABLE_IDX:
		result = Status.CONTACT_STATUS_UNAVAILABLE;
		break;
	    default:
		result = Status.CONTACT_STATUS_AVAILABLE;
		break;
	}
	return result;
    }
}
