/*
    BEEM is a videoconference application on the Android Platform.

    Copyright (C) 2009 by Frederic-Charles Barthelery,
                          Jean-Manuel Da Silva,
                          Nikita Kozlov,
                          Philippe Lago,
                          Jean Baptiste Vergely,
                          Vincent Veronis.

    This file is part of BEEM.

    BEEM is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    BEEM is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with BEEM.  If not, see <http://www.gnu.org/licenses/>.

    Please send bug reports with examples or suggestions to
    contact@beem-project.com or http://dev.beem-project.com/
 */

package com.beem.project.beem.account;

import android.accounts.Account;
import android.accounts.OperationCanceledException;
import android.content.AbstractThreadedSyncAdapter;
import android.content.ContentProviderClient;
import android.content.Context;
import android.content.SyncResult;
import android.os.Bundle;
import android.util.Log;

/**
 * Class to integrate beem in android's account
 * @author marseille
 */
public class SyncAdapter extends AbstractThreadedSyncAdapter {

    private Context mContext;
    private static final String TAG = "SyncAdapter";

    /**
     * Constructor.
     * @param context context
     * @param autoInitialize autoInitialize
     */
    public SyncAdapter(Context context, boolean autoInitialize) {
	super(context, autoInitialize);
	mContext = context;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public void onPerformSync(Account account, Bundle extras, String authority, ContentProviderClient provider,
	SyncResult syncResult) {
	try {
	    SyncAdapterService.performSync(mContext, account, extras, authority, provider, syncResult);
	} catch (OperationCanceledException e) {
	    Log.w(TAG, "Error while performSync", e);
	}

    }

    @Override
    public void onSyncCanceled() {
	super.onSyncCanceled();
	Log.e(TAG, "SYNCCANCELED");
    }

}
