/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.packet;

import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;
import org.jivesoftware.smack.packet.IQ;

public class Time
extends IQ {
    private static SimpleDateFormat utcFormat = new SimpleDateFormat("yyyyMMdd'T'HH:mm:ss");
    private static DateFormat displayFormat = DateFormat.getDateTimeInstance();
    private String utc = null;
    private String tz = null;
    private String display = null;

    public Time() {
    }

    public Time(Calendar calendar) {
        TimeZone timeZone = calendar.getTimeZone();
        this.tz = calendar.getTimeZone().getID();
        this.display = displayFormat.format(calendar.getTime());
        this.utc = utcFormat.format(new Date(calendar.getTimeInMillis() - (long)timeZone.getOffset(calendar.getTimeInMillis())));
    }

    public Date getTime() {
        if (this.utc == null) {
            return null;
        }
        Date date = null;
        try {
            Calendar calendar = Calendar.getInstance();
            calendar.setTime(new Date(utcFormat.parse(this.utc).getTime() + (long)calendar.getTimeZone().getOffset(calendar.getTimeInMillis())));
            date = calendar.getTime();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return date;
    }

    public void setTime(Date date) {
        this.utc = utcFormat.format(new Date(date.getTime() - (long)TimeZone.getDefault().getOffset(date.getTime())));
    }

    public String getUtc() {
        return this.utc;
    }

    public void setUtc(String string) {
        this.utc = string;
    }

    public String getTz() {
        return this.tz;
    }

    public void setTz(String string) {
        this.tz = string;
    }

    public String getDisplay() {
        return this.display;
    }

    public void setDisplay(String string) {
        this.display = string;
    }

    public String getChildElementXML() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("<query xmlns=\"jabber:iq:time\">");
        if (this.utc != null) {
            stringBuilder.append("<utc>").append(this.utc).append("</utc>");
        }
        if (this.tz != null) {
            stringBuilder.append("<tz>").append(this.tz).append("</tz>");
        }
        if (this.display != null) {
            stringBuilder.append("<display>").append(this.display).append("</display>");
        }
        stringBuilder.append("</query>");
        return stringBuilder.toString();
    }
}

