/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smack.packet;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.jivesoftware.smack.packet.Packet;
import org.jivesoftware.smack.packet.XMPPError;
import org.jivesoftware.smack.util.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Message
extends Packet {
    private Type type = Type.normal;
    private String subject = null;
    private String thread = null;
    private String language;
    private final Set<Body> bodies = new HashSet<Body>();

    public Message() {
    }

    public Message(String to) {
        this.setTo(to);
    }

    public Message(String to, Type type) {
        this.setTo(to);
        this.type = type;
    }

    public Type getType() {
        return this.type;
    }

    public void setType(Type type) {
        if (type == null) {
            throw new IllegalArgumentException("Type cannot be null.");
        }
        this.type = type;
    }

    public String getSubject() {
        return this.subject;
    }

    public void setSubject(String subject) {
        this.subject = subject;
    }

    public String getBody() {
        return this.getBody(null);
    }

    public String getBody(String language) {
        language = Message.parseXMLLang(language);
        for (Body body : this.bodies) {
            if ((body.langauge != null || language != null) && (body == null || !body.langauge.equals(language))) continue;
            return body.message;
        }
        return null;
    }

    public Collection<Body> getBodies() {
        return Collections.unmodifiableCollection(this.bodies);
    }

    public void setBody(String body) {
        if (body == null) {
            this.removeBody("");
            return;
        }
        this.addBody(null, body);
    }

    public Body addBody(String language, String body) {
        if (body == null) {
            throw new NullPointerException("Body must be specified");
        }
        language = Message.parseXMLLang(language);
        Body messageBody = new Body(language, body);
        this.bodies.add(messageBody);
        return messageBody;
    }

    public boolean removeBody(String language) {
        language = Message.parseXMLLang(language);
        for (Body body : this.bodies) {
            if (!language.equals(body.langauge)) continue;
            return this.bodies.remove(body);
        }
        return false;
    }

    public boolean removeBody(Body body) {
        return this.bodies.remove(body);
    }

    public Collection<String> getBodyLanguages() {
        ArrayList<String> languages = new ArrayList<String>(this.bodies.size());
        for (Body body : this.bodies) {
            if (Message.parseXMLLang(body.langauge).equals(Message.getDefaultLanguage())) continue;
            languages.add(body.langauge);
        }
        return Collections.unmodifiableCollection(languages);
    }

    public String getThread() {
        return this.thread;
    }

    public void setThread(String thread) {
        this.thread = thread;
    }

    private String getLanguage() {
        return this.language;
    }

    public void setLanguage(String language) {
        this.language = language;
    }

    @Override
    public String toXML() {
        XMPPError error;
        StringBuilder buf = new StringBuilder();
        buf.append("<message");
        if (this.getXmlns() != null) {
            buf.append(" xmlns=\"").append(this.getXmlns()).append("\"");
        }
        if (this.language != null) {
            buf.append(" xml:lang=\"").append(this.getLanguage()).append("\"");
        }
        if (this.getPacketID() != null) {
            buf.append(" id=\"").append(this.getPacketID()).append("\"");
        }
        if (this.getTo() != null) {
            buf.append(" to=\"").append(StringUtils.escapeForXML(this.getTo())).append("\"");
        }
        if (this.getFrom() != null) {
            buf.append(" from=\"").append(StringUtils.escapeForXML(this.getFrom())).append("\"");
        }
        if (this.type != Type.normal) {
            buf.append(" type=\"").append((Object)this.type).append("\"");
        }
        buf.append(">");
        if (this.subject != null) {
            buf.append("<subject>").append(StringUtils.escapeForXML(this.subject)).append("</subject>");
        }
        if (this.getBody() != null) {
            buf.append("<body>").append(StringUtils.escapeForXML(this.getBody())).append("</body>");
        }
        for (Body body : this.getBodies()) {
            if (DEFAULT_LANGUAGE.equals(body.getLanguage()) || body.getLanguage() == null) continue;
            buf.append("<body xml:lang=\"").append(body.getLanguage()).append("\">");
            buf.append(StringUtils.escapeForXML(body.getMessage()));
            buf.append("</body>");
        }
        if (this.thread != null) {
            buf.append("<thread>").append(this.thread).append("</thread>");
        }
        if (this.type == Type.error && (error = this.getError()) != null) {
            buf.append(error.toXML());
        }
        buf.append(this.getExtensionsXML());
        buf.append("</message>");
        return buf.toString();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Message message = (Message)o;
        if (!super.equals(message)) {
            return false;
        }
        if (this.bodies.size() != message.bodies.size() || !this.bodies.containsAll(message.bodies)) {
            return false;
        }
        if (this.language != null ? !this.language.equals(message.language) : message.language != null) {
            return false;
        }
        if (this.subject != null ? !this.subject.equals(message.subject) : message.subject != null) {
            return false;
        }
        if (this.thread != null ? !this.thread.equals(message.thread) : message.thread != null) {
            return false;
        }
        return this.type == message.type;
    }

    @Override
    public int hashCode() {
        int result = this.type != null ? this.type.hashCode() : 0;
        result = 31 * result + (this.subject != null ? this.subject.hashCode() : 0);
        result = 31 * result + (this.thread != null ? this.thread.hashCode() : 0);
        result = 31 * result + (this.language != null ? this.language.hashCode() : 0);
        result = 31 * result + ((Object)this.bodies).hashCode();
        return result;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Type {
        normal,
        chat,
        groupchat,
        headline,
        error;


        public static Type fromString(String name) {
            try {
                return Type.valueOf(name);
            }
            catch (Exception e) {
                return normal;
            }
        }
    }

    public static class Body {
        private String message;
        private String langauge;

        private Body(String language, String message) {
            if (message == null) {
                throw new NullPointerException("Message cannot be null.");
            }
            this.langauge = language;
            this.message = message;
        }

        public String getLanguage() {
            if (Packet.DEFAULT_LANGUAGE.equals(this.langauge)) {
                return null;
            }
            return this.langauge;
        }

        public String getMessage() {
            return this.message;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Body body = (Body)o;
            if (this.langauge != null ? !this.langauge.equals(body.langauge) : body.langauge != null) {
                return false;
            }
            return this.message.equals(body.message);
        }

        public int hashCode() {
            int result = this.message.hashCode();
            result = 31 * result + (this.langauge != null ? this.langauge.hashCode() : 0);
            return result;
        }
    }
}

