/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.packet;

import org.jivesoftware.smack.packet.PacketExtension;
import org.jivesoftware.smack.provider.PacketExtensionProvider;
import org.jivesoftware.smackx.jingle.media.ContentInfo;
import org.jivesoftware.smackx.packet.JingleContentInfo;
import org.xmlpull.v1.XmlPullParser;

public class JingleError
implements PacketExtension {
    public static String NAMESPACE = "urn:xmpp:tmp:jingle:errors";
    public static final JingleError OUT_OF_ORDER = new JingleError("out-of-order");
    public static final JingleError UNKNOWN_SESSION = new JingleError("unknown-session");
    public static final JingleError UNSUPPORTED_CONTENT = new JingleError("unsupported-content");
    public static final JingleError UNSUPPORTED_TRANSPORTS = new JingleError("unsupported-transports");
    public static final JingleError NO_COMMON_PAYLOAD = new JingleError("unsupported-codecs");
    public static final JingleError NEGOTIATION_ERROR = new JingleError("negotiation-error");
    public static final JingleError MALFORMED_STANZA = new JingleError("malformed-stanza");
    private String message;

    public JingleError(String string) {
        this.message = string;
    }

    public String getMessage() {
        return this.message;
    }

    public String toXML() {
        StringBuilder stringBuilder = new StringBuilder();
        if (this.message != null) {
            stringBuilder.append("<error type=\"cancel\">");
            stringBuilder.append("<").append(this.message).append(" xmlns=\"").append(NAMESPACE).append("\"/>");
            stringBuilder.append("</error>");
        }
        return stringBuilder.toString();
    }

    public static JingleError fromString(String string) {
        if (string != null) {
            if ((string = string.toLowerCase()).equals("out-of-order")) {
                return OUT_OF_ORDER;
            }
            if (string.equals("unknown-session")) {
                return UNKNOWN_SESSION;
            }
            if (string.equals("unsupported-content")) {
                return UNSUPPORTED_CONTENT;
            }
            if (string.equals("unsupported-transports")) {
                return UNSUPPORTED_TRANSPORTS;
            }
            if (string.equals("unsupported-codecs")) {
                return NO_COMMON_PAYLOAD;
            }
            if (string.equals("negotiation-error")) {
                return NEGOTIATION_ERROR;
            }
            if (string.equals("malformed-stanza")) {
                return MALFORMED_STANZA;
            }
        }
        return null;
    }

    public String toString() {
        return this.getMessage();
    }

    public String getElementName() {
        return this.message;
    }

    public String getNamespace() {
        return NAMESPACE;
    }

    public static class Provider
    implements PacketExtensionProvider {
        private PacketExtension audioInfo;

        public PacketExtension parseExtension(XmlPullParser xmlPullParser) throws Exception {
            PacketExtension packetExtension = null;
            if (this.audioInfo != null) {
                packetExtension = this.audioInfo;
            } else {
                String string = xmlPullParser.getName();
                ContentInfo contentInfo = ContentInfo.Audio.fromString(string);
                if (contentInfo != null) {
                    packetExtension = new JingleContentInfo.Audio(contentInfo);
                }
            }
            return packetExtension;
        }
    }
}

