/*
    BEEM is a videoconference application on the Android Platform.

    Copyright (C) 2009 by Frederic-Charles Barthelery,
                          Jean-Manuel Da Silva,
                          Nikita Kozlov,
                          Philippe Lago,
                          Jean Baptiste Vergely,
                          Vincent Veronis.

    This file is part of BEEM.

    BEEM is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    BEEM is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with BEEM.  If not, see <http://www.gnu.org/licenses/>.

    Please send bug reports with examples or suggestions to
    contact@beem-project.com or http://dev.beem-project.com/
 */

package com.beem.project.beem.ui;

import android.app.Activity;
import android.content.ComponentName;
import android.content.Intent;
import android.content.SharedPreferences;
import android.os.Bundle;
import android.view.View;
import android.view.View.OnClickListener;
import android.widget.ArrayAdapter;
import android.widget.Button;
import android.widget.EditText;
import android.widget.Spinner;

import com.beem.project.beem.BeemApplication;
import com.beem.project.beem.BeemIntent;
import com.beem.project.beem.R;
import com.beem.project.beem.ui.wizard.AccountConfigure;
import com.beem.project.beem.utils.Status;

/**
 * This Activity is used to change the status.
 * @author nikita
 */
public class ChangeStatus extends Activity {

    private static final Intent SERVICE_INTENT = new Intent();
    static {
	SERVICE_INTENT.setComponent(new ComponentName("com.beem.project.beem", "com.beem.project.beem.BeemService"));
    }

    private static final int AVAILABLE_FOR_CHAT_IDX = 0;
    private static final int AVAILABLE_IDX = 1;
    private static final int BUSY_IDX = 2;
    private static final int AWAY_IDX = 3;
    private static final int UNAVAILABLE_IDX = 4;
    private static final int DISCONNECTED_IDX = 5;

    private EditText mStatusMessageEditText;
    private Button mOk;
    private Button mClear;
    private Button mContact;
    private Spinner mSpinner;

    private SharedPreferences mSettings;
    private ArrayAdapter<CharSequence> mAdapter;
    private final OnClickListener mOnClickOk = new MyOnClickListener();
    private String mAccount;

    /**
     * Constructor.
     */
    public ChangeStatus() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    protected void onCreate(Bundle savedInstanceState) {
	super.onCreate(savedInstanceState);
	setContentView(R.layout.changestatus);
	Bundle b = getIntent().getExtras();
	if (b == null) {
	    //TODO: Add toast to advice need to configure at least 1 beem account (Should not happend)
	    startActivity(new Intent(ChangeStatus.this, AccountConfigure.class));
	}
	mAccount = b.getString(BeemIntent.EXTRA_ACCOUNT);
	if (mAccount == null) {
	    //TODO: Add toast to advice need to configure at least 1 beem account (Should not happend)
	    startActivity(new Intent(ChangeStatus.this, AccountConfigure.class));
	}
	mSettings = getSharedPreferences(mAccount, MODE_PRIVATE);
	mOk = (Button) findViewById(R.id.ChangeStatusOk);
	mOk.setOnClickListener(mOnClickOk);

	mClear = (Button) findViewById(R.id.ChangeStatusClear);
	mClear.setOnClickListener(mOnClickOk);

	mContact = (Button) findViewById(R.id.OpenContactList);
	mContact.setOnClickListener(mOnClickOk);

	mStatusMessageEditText = (EditText) findViewById(R.id.ChangeStatusMessage);
	mStatusMessageEditText.setText(mSettings.getString(BeemApplication.STATUS_TEXT_KEY, ""));

	mSpinner = (Spinner) findViewById(R.id.ChangeStatusSpinner);
	mAdapter = ArrayAdapter.createFromResource(this, R.array.status_types, android.R.layout.simple_spinner_item);
	mAdapter.setDropDownViewResource(android.R.layout.simple_spinner_dropdown_item);
	mSpinner.setAdapter(mAdapter);
	mSpinner.setSelection(fillSpinnerFromSettings(mSettings.getInt(BeemApplication.STATUS_KEY, AVAILABLE_IDX)));

    }

    @Override
    protected void onResume() {
	super.onResume();
	Bundle b = getIntent().getExtras();
	if (b != null && b.containsKey(BeemIntent.EXTRA_ACCOUNT))
	    mAccount = b.getString(BeemIntent.EXTRA_ACCOUNT);
    }

    /**
     * convert status text to.
     * @param item selected item text.
     * @return item position in the array.
     */
    private int getStatusForService(String item) {
	int result;
	switch (mAdapter.getPosition(item)) {
	    case ChangeStatus.DISCONNECTED_IDX:
		result = Status.CONTACT_STATUS_DISCONNECT;
		break;
	    case ChangeStatus.AVAILABLE_FOR_CHAT_IDX:
		result = Status.CONTACT_STATUS_AVAILABLE_FOR_CHAT;
		break;
	    case ChangeStatus.AVAILABLE_IDX:
		result = Status.CONTACT_STATUS_AVAILABLE;
		break;
	    case ChangeStatus.AWAY_IDX:
		result = Status.CONTACT_STATUS_AWAY;
		break;
	    case ChangeStatus.BUSY_IDX:
		result = Status.CONTACT_STATUS_BUSY;
		break;
	    case ChangeStatus.UNAVAILABLE_IDX:
		result = Status.CONTACT_STATUS_UNAVAILABLE;
		break;
	    default:
		result = Status.CONTACT_STATUS_AVAILABLE;
		break;
	}
	return result;
    }

    /**
     * convert settings to spinner.
     * @param item selected item text.
     * @return item position in the array.
     */
    private int fillSpinnerFromSettings(int status) {
	int result;
	switch (status) {
	    case Status.CONTACT_STATUS_DISCONNECT:
		result = DISCONNECTED_IDX;
		break;
	    case Status.CONTACT_STATUS_UNAVAILABLE:
		result = UNAVAILABLE_IDX;
		break;
	    case Status.CONTACT_STATUS_AWAY:
		result = AWAY_IDX;
		break;
	    case Status.CONTACT_STATUS_BUSY:
		result = BUSY_IDX;
		break;
	    case Status.CONTACT_STATUS_AVAILABLE:
		result = AVAILABLE_IDX;
		break;
	    case Status.CONTACT_STATUS_AVAILABLE_FOR_CHAT:
		result = AVAILABLE_FOR_CHAT_IDX;
		break;
	    default:
		result = UNAVAILABLE_IDX;
		break;
	}
	return result;
    }

    /**
     * User have clicked on ok.
     * @author nikita
     */
    private class MyOnClickListener implements OnClickListener {

	/**
	 * constructor.
	 */
	public MyOnClickListener() {
	}

	@Override
	public void onClick(View v) {
	    if (v == mOk) {
		String msg = mStatusMessageEditText.getText().toString();
		int status = getStatusForService((String) mSpinner.getSelectedItem());
		Bundle b = new Bundle();
		b.putInt(BeemApplication.STATUS_KEY, status);
		b.putString(BeemApplication.STATUS_TEXT_KEY, msg);
		Intent intent = new Intent(BeemIntent.ACTION_CHANGE_STATUS);
		intent.putExtra(BeemIntent.EXTRA_ACCOUNT, mAccount);
		intent.putExtra(BeemIntent.EXTRA_MESSAGE, b);
		startService(intent);
		ChangeStatus.this.finish();
	    } else if (v == mClear) {
		mStatusMessageEditText.setText(null);
	    } else if (v == mContact) {
		startActivity(new Intent(ChangeStatus.this, ContactList.class));
		ChangeStatus.this.finish();
	    }
	}
    }
}
