/*
 * Decompiled with CFR 0.152.
 */
package org.jlibrtp.jlibrtp;

import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.MulticastSocket;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.LinkedList;
import java.util.ListIterator;
import org.jlibrtp.jlibrtp.Participant;
import org.jlibrtp.jlibrtp.RTCPReceiverThread;
import org.jlibrtp.jlibrtp.RTCPSenderThread;
import org.jlibrtp.jlibrtp.RTPSession;
import org.jlibrtp.jlibrtp.RtcpPkt;
import org.jlibrtp.jlibrtp.RtcpPktAPP;
import org.jlibrtp.jlibrtp.RtcpPktPSFB;
import org.jlibrtp.jlibrtp.RtcpPktRTPFB;

public class RTCPSession {
    protected RTPSession rtpSession = null;
    protected DatagramSocket rtcpSock = null;
    protected MulticastSocket rtcpMCSock = null;
    protected InetAddress mcGroup = null;
    protected RTCPReceiverThread recvThrd = null;
    protected RTCPSenderThread senderThrd = null;
    protected long prevTime = System.currentTimeMillis();
    protected int nextDelay = -1;
    protected int avgPktSize = 200;
    protected int senderCount = 1;
    protected boolean fbAllowEarly = false;
    protected Hashtable<Long, LinkedList<RtcpPkt>> fbQueue = null;
    protected Hashtable<Long, LinkedList<RtcpPktAPP>> appQueue = null;
    protected boolean initial = true;
    protected long fbWaiting = -1L;

    protected RTCPSession(RTPSession parent, DatagramSocket rtcpSocket) {
        this.rtcpSock = rtcpSocket;
        this.rtpSession = parent;
    }

    protected RTCPSession(RTPSession parent, MulticastSocket rtcpSocket, InetAddress multicastGroup) {
        this.mcGroup = multicastGroup;
        this.rtcpSock = rtcpSocket;
        this.rtpSession = parent;
    }

    protected void start() {
        this.calculateDelay();
        this.recvThrd = new RTCPReceiverThread(this, this.rtpSession);
        this.senderThrd = new RTCPSenderThread(this, this.rtpSession);
        this.recvThrd.start();
        this.senderThrd.start();
    }

    protected void sendByes() {
        this.senderThrd.sendByes();
    }

    protected void calculateDelay() {
        switch (this.rtpSession.rtcpMode) {
            case 0: {
                this.calculateRegularDelay();
                break;
            }
            default: {
                System.out.println("RTCPSession.calculateDelay() unknown .mode");
            }
        }
    }

    protected void calculateRegularDelay() {
        int rand;
        long curTime = System.currentTimeMillis();
        if (this.rtpSession.bandwidth != 0 && !this.initial && this.rtpSession.partDb.ssrcTable.size() > 4) {
            rand = this.rtpSession.random.nextInt(10000) - 5000;
            double randDouble = (1000.0 + (double)rand) / 1000.0;
            Enumeration<Participant> enu = this.rtpSession.partDb.getParticipants();
            while (enu.hasMoreElements()) {
                Participant part = enu.nextElement();
                if (part.lastRtpPkt <= this.prevTime) continue;
                ++this.senderCount;
            }
            double bw = this.rtpSession.rtcpBandwidth > -1 ? (double)this.rtpSession.rtcpBandwidth : (double)this.rtpSession.bandwidth * 0.05;
            if (this.senderCount * 2 > this.rtpSession.partDb.ssrcTable.size()) {
                if (this.rtpSession.lastTimestamp > this.prevTime) {
                    double numerator = (double)this.avgPktSize * (double)this.senderCount;
                    double denominator = 0.25 * bw;
                    this.nextDelay = (int)Math.round(numerator / denominator * randDouble);
                } else {
                    double numerator = (double)this.avgPktSize * (double)this.rtpSession.partDb.ssrcTable.size();
                    double denominator = 0.75 * bw;
                    this.nextDelay = (int)Math.round(numerator / denominator * randDouble);
                }
            } else {
                double numerator = (double)this.avgPktSize * (double)this.rtpSession.partDb.ssrcTable.size();
                double denominator = bw;
                this.nextDelay = (int)Math.round(1000.0 * (numerator / denominator)) * (1000 + rand);
            }
        } else {
            rand = this.rtpSession.random.nextInt(1000) - 500;
            if (this.initial) {
                this.nextDelay = 3000 + rand;
                this.initial = false;
            } else {
                this.nextDelay = 5500 + rand;
            }
        }
        if (this.nextDelay < 1000) {
            rand = this.rtpSession.random.nextInt(1000) - 500;
            this.nextDelay = 2000 + rand;
            System.out.println("RTCPSession.calculateDelay() nextDelay was too short (" + this.nextDelay + "ms), setting to " + this.nextDelay);
        }
        this.prevTime = curTime;
    }

    protected synchronized void updateAvgPacket(int length) {
        double tempAvg = this.avgPktSize;
        tempAvg = (15.0 * tempAvg + (double)length) / 16.0;
        this.avgPktSize = (int)tempAvg;
    }

    protected synchronized void addToAppQueue(long targetSsrc, RtcpPktAPP aPkt) {
        LinkedList<RtcpPktAPP> ll;
        aPkt.time = System.currentTimeMillis();
        if (this.appQueue == null) {
            this.appQueue = new Hashtable();
        }
        if ((ll = this.appQueue.get(targetSsrc)) == null) {
            ll = new LinkedList();
            this.appQueue.put(targetSsrc, ll);
        }
        ll.add(aPkt);
    }

    protected synchronized RtcpPktAPP[] getFromAppQueue(long targetSsrc) {
        if (this.appQueue == null) {
            return null;
        }
        LinkedList<RtcpPktAPP> ll = this.appQueue.get(targetSsrc);
        if (ll == null || ll.isEmpty()) {
            return null;
        }
        RtcpPktAPP[] ret = new RtcpPktAPP[ll.size()];
        ListIterator li = ll.listIterator();
        int i = 0;
        while (li.hasNext()) {
            ret[i] = (RtcpPktAPP)li.next();
            ++i;
        }
        return ret;
    }

    protected synchronized void cleanAppQueue(long ssrc) {
        if (this.appQueue == null) {
            return;
        }
        if (ssrc > 0L) {
            this.appQueue.remove(ssrc);
        } else {
            Enumeration<LinkedList<RtcpPktAPP>> enu = this.appQueue.elements();
            long curTime = System.currentTimeMillis();
            while (enu.hasMoreElements()) {
                ListIterator li = enu.nextElement().listIterator();
                while (li.hasNext()) {
                    RtcpPkt aPkt = (RtcpPkt)li.next();
                    if (curTime - aPkt.time <= 60000L) continue;
                    li.remove();
                }
            }
        }
    }

    protected synchronized int addToFbQueue(long targetSsrc, RtcpPkt aPkt) {
        LinkedList<RtcpPkt> ll;
        if (this.fbQueue == null) {
            this.fbQueue = new Hashtable();
        }
        if ((ll = this.fbQueue.get(targetSsrc)) == null) {
            ll = new LinkedList();
            ll.add(aPkt);
            this.fbQueue.put(targetSsrc, ll);
        } else {
            ListIterator li = ll.listIterator();
            while (li.hasNext()) {
                RtcpPkt tmp = (RtcpPkt)li.next();
                if (!this.equivalent(tmp, aPkt)) continue;
                return -1;
            }
            ll.addLast(aPkt);
        }
        return 0;
    }

    protected synchronized RtcpPkt[] getFromFbQueue(long ssrc) {
        if (this.fbQueue == null) {
            return null;
        }
        LinkedList<RtcpPkt> ll = this.fbQueue.get(ssrc);
        if (ll == null) {
            return null;
        }
        ListIterator li = ll.listIterator();
        if (li.hasNext()) {
            long curTime = System.currentTimeMillis();
            long maxDelay = curTime - (long)this.rtpSession.fbMaxDelay;
            long keepDelay = curTime - 2000L;
            int count = 0;
            while (li.hasNext()) {
                RtcpPkt aPkt = (RtcpPkt)li.next();
                if (aPkt.received) {
                    if (aPkt.time >= keepDelay) continue;
                    li.remove();
                    continue;
                }
                if (aPkt.time < maxDelay) {
                    li.remove();
                    continue;
                }
                ++count;
            }
            if (count != 0) {
                li = ll.listIterator();
                RtcpPkt[] ret = new RtcpPkt[count];
                while (count > 0) {
                    RtcpPkt aPkt = (RtcpPkt)li.next();
                    if (aPkt.received) continue;
                    ret[ret.length - count] = aPkt;
                    --count;
                }
                return ret;
            }
        }
        return null;
    }

    protected synchronized void cleanFbQueue(long ssrc) {
        if (this.fbQueue == null) {
            return;
        }
        if (ssrc > 0L) {
            this.fbQueue.remove(ssrc);
        } else {
            Enumeration<LinkedList<RtcpPkt>> enu = this.fbQueue.elements();
            long curTime = System.currentTimeMillis();
            long maxDelay = curTime - (long)this.rtpSession.fbMaxDelay;
            long keepDelay = curTime - 2000L;
            while (enu.hasMoreElements()) {
                ListIterator li = enu.nextElement().listIterator();
                while (li.hasNext()) {
                    RtcpPkt aPkt = (RtcpPkt)li.next();
                    if (aPkt.received) {
                        if (aPkt.time >= keepDelay) continue;
                        li.remove();
                        continue;
                    }
                    if (aPkt.time >= maxDelay) continue;
                    li.remove();
                }
            }
        }
    }

    protected boolean fbSendImmediately() {
        return this.rtpSession.partDb.ssrcTable.size() <= this.rtpSession.fbEarlyThreshold || this.rtpSession.partDb.receivers.size() <= this.rtpSession.fbEarlyThreshold;
    }

    protected boolean fbSendEarly() {
        return this.rtpSession.partDb.ssrcTable.size() <= this.rtpSession.fbRegularThreshold || this.rtpSession.partDb.receivers.size() <= this.rtpSession.fbRegularThreshold;
    }

    protected void wakeSenderThread(long ssrc) {
        this.fbWaiting = ssrc;
        this.senderThrd.interrupt();
        try {
            Thread.sleep(0L, 1);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private boolean equivalent(RtcpPkt one, RtcpPkt two) {
        if (one.packetType != two.packetType) {
            return false;
        }
        if (one.itemCount != two.itemCount) {
            return false;
        }
        if (one.packetType == 205) {
            RtcpPktRTPFB pktone = (RtcpPktRTPFB)one;
            RtcpPktRTPFB pkttwo = (RtcpPktRTPFB)two;
            if (pktone.ssrcMediaSource != pkttwo.ssrcMediaSource) {
                return false;
            }
            if (Arrays.equals(pktone.BLP, pkttwo.BLP) && Arrays.equals(pktone.BLP, pkttwo.BLP)) {
                return true;
            }
            return true;
        }
        if (one.packetType == 206) {
            RtcpPktPSFB pktone = (RtcpPktPSFB)one;
            RtcpPktPSFB pkttwo = (RtcpPktPSFB)two;
            if (pktone.ssrcMediaSource != pkttwo.ssrcMediaSource) {
                return false;
            }
            switch (one.itemCount) {
                case 1: {
                    return true;
                }
                case 2: {
                    if (pktone.sliFirst.length != pkttwo.sliFirst.length || !Arrays.equals(pktone.sliFirst, pkttwo.sliFirst) || !Arrays.equals(pktone.sliNumber, pkttwo.sliNumber) || !Arrays.equals(pktone.sliPictureId, pkttwo.sliPictureId)) break;
                    return true;
                }
                case 3: {
                    if (!Arrays.equals(pktone.rpsiBitString, pkttwo.rpsiBitString)) break;
                    return true;
                }
                case 15: {
                    if (pktone.sliFirst.length != pkttwo.sliFirst.length || !Arrays.equals(pktone.alfBitString, pkttwo.alfBitString)) break;
                    return true;
                }
            }
            return true;
        }
        System.out.println("!!!! RTCPSession.equivalentPackets() encountered unexpected packet type!");
        return false;
    }
}

