/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smack;

import org.jivesoftware.smack.ConnectionCreationListener;
import org.jivesoftware.smack.ConnectionListener;
import org.jivesoftware.smack.XMPPConnection;
import org.jivesoftware.smack.XMPPException;
import org.jivesoftware.smack.packet.StreamError;

public class ReconnectionManager
implements ConnectionListener {
    private XMPPConnection connection;
    boolean done = false;

    private ReconnectionManager(XMPPConnection connection) {
        this.connection = connection;
    }

    private boolean isReconnectionAllowed() {
        return !this.done && !this.connection.isConnected() && this.connection.getConfiguration().isReconnectionAllowed() && this.connection.packetReader != null;
    }

    protected void reconnect() {
        if (this.isReconnectionAllowed()) {
            Thread reconnectionThread = new Thread(){
                private int attempts = 0;

                private int timeDelay() {
                    if (this.attempts > 13) {
                        return 300;
                    }
                    if (this.attempts > 7) {
                        return 60;
                    }
                    return 10;
                }

                public void run() {
                    while (ReconnectionManager.this.isReconnectionAllowed()) {
                        int remainingSeconds = this.timeDelay();
                        while (ReconnectionManager.this.isReconnectionAllowed() && remainingSeconds > 0) {
                            try {
                                Thread.sleep(1000L);
                                ReconnectionManager.this.notifyAttemptToReconnectIn(--remainingSeconds);
                            }
                            catch (InterruptedException e1) {
                                e1.printStackTrace();
                                ReconnectionManager.this.notifyReconnectionFailed(e1);
                            }
                        }
                        try {
                            if (!ReconnectionManager.this.isReconnectionAllowed()) continue;
                            ReconnectionManager.this.connection.connect();
                        }
                        catch (XMPPException e) {
                            ReconnectionManager.this.notifyReconnectionFailed(e);
                        }
                    }
                }
            };
            reconnectionThread.setName("Smack Reconnection Manager");
            reconnectionThread.setDaemon(true);
            reconnectionThread.start();
        }
    }

    protected void notifyReconnectionFailed(Exception exception) {
        if (this.isReconnectionAllowed()) {
            for (ConnectionListener listener : this.connection.packetReader.connectionListeners) {
                listener.reconnectionFailed(exception);
            }
        }
    }

    protected void notifyAttemptToReconnectIn(int seconds) {
        if (this.isReconnectionAllowed()) {
            for (ConnectionListener listener : this.connection.packetReader.connectionListeners) {
                listener.reconnectingIn(seconds);
            }
        }
    }

    public void connectionClosed() {
        this.done = true;
    }

    public void connectionClosedOnError(Exception e) {
        String reason;
        XMPPException xmppEx;
        StreamError error;
        this.done = false;
        if (e instanceof XMPPException && (error = (xmppEx = (XMPPException)e).getStreamError()) != null && "conflict".equals(reason = error.getCode())) {
            return;
        }
        if (this.isReconnectionAllowed()) {
            this.reconnect();
        }
    }

    public void reconnectingIn(int seconds) {
    }

    public void reconnectionFailed(Exception e) {
    }

    public void reconnectionSuccessful() {
    }

    static {
        XMPPConnection.addConnectionCreationListener(new ConnectionCreationListener(){

            public void connectionCreated(XMPPConnection connection) {
                connection.addConnectionListener(new ReconnectionManager(connection));
            }
        });
    }
}

