/*
    BEEM is a videoconference application on the Android Platform.

    Copyright (C) 2009 by Frederic-Charles Barthelery,
                          Jean-Manuel Da Silva,
                          Nikita Kozlov,
                          Philippe Lago,
                          Jean Baptiste Vergely,
                          Vincent Veronis.

    This file is part of BEEM.

    BEEM is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    BEEM is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with BEEM.  If not, see <http://www.gnu.org/licenses/>.

    Please send bug reports with examples or suggestions to
    contact@beem-project.com or http://dev.beem-project.com/
 */

package com.beem.project.beem.providers;

import android.net.Uri;
import android.provider.BaseColumns;

public class Messages implements BaseColumns {

    /**
     * Constructor.
     */
    public Messages() {

    }

    public static final Uri CONTENT_URI = Uri.parse("content://" + MessageProvider.AUTHORITY + "/messages");
    public static final String CONTENT_TYPE = "vnd.android.cursor.dir/vnd.com.beem.project.beem.provider.messages";

    public static final String _ID = "_id";
    public static final String FROM = "_FROM";
    public static final String MESSAGE_ID = "_MESSAGE_ID";
    public static final String TO = "_TO";
    public static final String TYPE = "_TYPE";
    public static final String SUBJECT = "_SUBJECT";
    public static final String BODY = "_BODY";
    public static final String THREAD = "_THREAD";
    public static final String EXTRAS = "_EXTRAS";
    public static final String IS_RECEIVE = "_IS_RECEIVE";
    public static final String DATE_RECEIVE = "_DATE_RECEIVE";
    public static final String DATE_READ = "_DATE_READ";

}
