/*
    BEEM is a videoconference application on the Android Platform.

    Copyright (C) 2009 by Frederic-Charles Barthelery,
                          Jean-Manuel Da Silva,
                          Nikita Kozlov,
                          Philippe Lago,
                          Jean Baptiste Vergely,
                          Vincent Veronis.

    This file is part of BEEM.

    BEEM is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    BEEM is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with BEEM.  If not, see <http://www.gnu.org/licenses/>.

    Please send bug reports with examples or suggestions to
    contact@beem-project.com or http://dev.beem-project.com/

    Epitech, hereby disclaims all copyright interest in the program "Beem"
    written by Frederic-Charles Barthelery,
               Jean-Manuel Da Silva,
               Nikita Kozlov,
               Philippe Lago,
               Jean Baptiste Vergely,
               Vincent Veronis.

    Nicolas Sadirac, November 26, 2009
    President of Epitech.

    Flavien Astraud, November 26, 2009
    Head of the EIP Laboratory.

 */

package com.beem.project.beem;

import org.jivesoftware.smack.ConnectionConfiguration;

import org.jivesoftware.smack.ConnectionConfiguration.SecurityMode;
import org.jivesoftware.smack.proxy.ProxyInfo;
import org.jivesoftware.smack.proxy.ProxyInfo.ProxyType;
import org.jivesoftware.smack.util.StringUtils;

import android.content.SharedPreferences;

/**
 * Class for connection informations
 * @author marseille
 */
public class BeemInfoConnection {

    private static final int DEFAULT_XMPP_PORT = 5222;

    private String mLogin;
    private String mJid;
    private String mPassword;
    private String mHost;
    private String mService;
    private String mResource;
    private int mPort;
    private ConnectionConfiguration mConnectionConfiguration;
    private ProxyInfo mProxyInfo;
    private boolean mUseProxy;

    private SharedPreferences mSettings;

    /**
     * Constructor.
     */
    public BeemInfoConnection(SharedPreferences settings) {
	mSettings = settings;

	mJid = mSettings.getString(BeemApplication.ACCOUNT_USERNAME_KEY, "");
	mLogin = StringUtils.parseName(mJid);
	mPassword = mSettings.getString(BeemApplication.ACCOUNT_PASSWORD_KEY, "");
	mPort = DEFAULT_XMPP_PORT;
	mService = StringUtils.parseServer(mJid);
	mHost = mService;
	mResource = mSettings.getString(BeemApplication.RESOURCE_KEY, "BEEM");

	if (mSettings.getBoolean("settings_key_specific_server", false)) {
	    mHost = mSettings.getString("settings_key_xmpp_server", "");
	    if ("".equals(mHost))
		mHost = mService;
	    String tmpPort = mSettings.getString("settings_key_xmpp_port", "5222");
	    mPort = ("".equals(tmpPort)) ? DEFAULT_XMPP_PORT : Integer.parseInt(tmpPort);
	}
	if (mSettings.getBoolean(BeemApplication.FULL_JID_LOGIN_KEY, false) || "gmail.com".equals(mService)
	    || "googlemail.com".equals(mService)) {
	    mLogin = mJid;
	}
	initConnectionConfig();

    }

    /**
     * Initialize the connection.
     */
    private void initConnectionConfig() {
	mUseProxy = mSettings.getBoolean(BeemApplication.PROXY_USE_KEY, false);
	if (mUseProxy) {
	    String stype = mSettings.getString(BeemApplication.PROXY_TYPE_KEY, "HTTP");
	    String phost = mSettings.getString(BeemApplication.PROXY_SERVER_KEY, "");
	    String puser = mSettings.getString(BeemApplication.PROXY_USERNAME_KEY, "");
	    String ppass = mSettings.getString(BeemApplication.PROXY_PASSWORD_KEY, "");
	    int pport = Integer.parseInt(mSettings.getString(BeemApplication.PROXY_PORT_KEY, "1080"));
	    ProxyInfo.ProxyType type = ProxyType.valueOf(stype);
	    mProxyInfo = new ProxyInfo(type, phost, pport, puser, ppass);
	} else {
	    mProxyInfo = ProxyInfo.forNoProxy();
	}
	if (mSettings.getBoolean("settings_key_specific_server", false))
	    mConnectionConfiguration = new ConnectionConfiguration(mHost, mPort, mService, mProxyInfo);
	else
	    mConnectionConfiguration = new ConnectionConfiguration(mService, mProxyInfo);

	if (mSettings.getBoolean("settings_key_xmpp_tls_use", false)
	    || mSettings.getBoolean("settings_key_gmail", false)) {
	    mConnectionConfiguration.setSecurityMode(SecurityMode.required);
	}
	if (mSettings.getBoolean(BeemApplication.SMACK_DEBUG_KEY, false))
	    mConnectionConfiguration.setDebuggerEnabled(true);
	mConnectionConfiguration.setSendPresence(true);
	// maybe not the universal path, but it works on most devices (Samsung Galaxy, Google Nexus One)
	mConnectionConfiguration.setTruststoreType("BKS");
	mConnectionConfiguration.setTruststorePath("/system/etc/security/cacerts.bks");
    }

    /**
     * Edit presence ex. SyncAdapter = false
     */
    public void setPresence(boolean bPresence) {
	mConnectionConfiguration.setSendPresence(bPresence);
    }

    /**
     * @return the login
     */
    public String getLogin() {
	return mLogin;
    }

    /**
     * @param login the login to set
     */
    public void setLogin(String login) {
	this.mLogin = login;
    }

    /**
     * @return the connectionConfiguration
     */
    public ConnectionConfiguration getConnectionConfiguration() {
	return mConnectionConfiguration;
    }

    /**
     * @param connectionConfiguration the connectionConfiguration to set
     */
    public void setConnectionConfiguration(ConnectionConfiguration connectionConfiguration) {
	this.mConnectionConfiguration = connectionConfiguration;
    }

    /**
     * @return the password
     */
    public String getPassword() {
	return mPassword;
    }

    /**
     * @param password the password to set
     */
    public void setPassword(String password) {
	this.mPassword = password;
    }

    /**
     * @return the settings
     */
    public SharedPreferences getSettings() {
	return mSettings;
    }

    /**
     * @param settings the settings to set
     */
    public void setSettings(SharedPreferences settings) {
	this.mSettings = settings;
    }

    /**
     * @return the jid
     */
    public String getJid() {
	return mJid;
    }

    /**
     * @param jid the jid to set
     */
    public void setJid(String jid) {
	this.mJid = jid;
    }
    
    /**
     * @return the resource
     */
    public String getResource() {
	return mResource;
    }
    
    /**
     * @param the resource
     */
    public void setResource(String resource) {
	mResource = resource;
    }
}
