/*
    BEEM is a videoconference application on the Android Platform.

    Copyright (C) 2009 by Frederic-Charles Barthelery,
                          Jean-Manuel Da Silva,
                          Nikita Kozlov,
                          Philippe Lago,
                          Jean Baptiste Vergely,
                          Vincent Veronis.

    This file is part of BEEM.

    BEEM is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    BEEM is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with BEEM.  If not, see <http://www.gnu.org/licenses/>.

    Please send bug reports with examples or suggestions to
    contact@beem-project.com or http://dev.beem-project.com/
 */

package com.beem.project.beem.account;

import android.accounts.AbstractAccountAuthenticator;
import android.accounts.Account;
import android.accounts.AccountAuthenticatorResponse;
import android.accounts.AccountManager;
import android.accounts.NetworkErrorException;
import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.util.Log;

import com.beem.project.beem.ui.wizard.AccountConfigure;

/**
 * Class to integrate beem in android's account
 * @author marseille 
 */
public class Authenticator extends AbstractAccountAuthenticator {

    private Context mContext;

    /**
     * Contructor
     * @param context context 
     */
    public Authenticator(Context context) {
	super(context);
	mContext = context;
    }
    
    /**
     * {@inheritDoc}
     */
    @Override
    public Bundle addAccount(AccountAuthenticatorResponse response, String accountType, String authTokenType,
	String[] requiredFeatures, Bundle options) throws NetworkErrorException {
	Log.v("AUTHENTICATOR", "Add account request type " + accountType + " token " + authTokenType + " features  " + requiredFeatures + " option " + options);

	Intent intent = new Intent(mContext, AccountConfigure.class);
	intent.putExtra(AccountManager.KEY_ACCOUNT_AUTHENTICATOR_RESPONSE, response);
	Bundle reply = new Bundle();
	reply.putParcelable(AccountManager.KEY_INTENT, intent);
	return reply;
    }


    /**
     * {@inheritDoc}
     */
    @Override
    public Bundle confirmCredentials(AccountAuthenticatorResponse response, Account account, Bundle options)
	throws NetworkErrorException {
	Log.e("AUTHENTICATOR", "CONFIRM CREDENTIAL");
	return null;
    }


    /**
     * {@inheritDoc}
     */
    @Override
    public Bundle editProperties(AccountAuthenticatorResponse response, String accountType) {
	Log.e("AUTHENTICATOR", "edit properties");
	return null;
    }


    /**
     * {@inheritDoc}
     */
    @Override
    public Bundle getAuthToken(AccountAuthenticatorResponse response, Account account, String authTokenType,
	Bundle options) throws NetworkErrorException {
	Log.e("AUTHENTICATOR", "get auth token");
	return null;
    }


    /**
     * {@inheritDoc}
     */
    @Override
    public String getAuthTokenLabel(String authTokenType) {
	Log.e("AUTHENTICATOR", "get auth token label");
	return null;
    }


    /**
     * {@inheritDoc}
     */
    @Override
    public Bundle hasFeatures(AccountAuthenticatorResponse response, Account account, String[] features)
	throws NetworkErrorException {
	Log.e("AUTHENTICATOR", "has features");
	return null;
    }


    /**
     * {@inheritDoc}
     */
    @Override
    public Bundle updateCredentials(AccountAuthenticatorResponse response, Account account, String authTokenType,
	Bundle options) throws NetworkErrorException {
	Log.e("AUTHENTICATOR", "update credentials");
	return null;
	
    }

}
