/*
    BEEM is a videoconference application on the Android Platform.

    Copyright (C) 2009 by Frederic-Charles Barthelery,
                          Jean-Manuel Da Silva,
                          Nikita Kozlov,
                          Philippe Lago,
                          Jean Baptiste Vergely,
                          Vincent Veronis.

    This file is part of BEEM.

    BEEM is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    BEEM is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with BEEM.  If not, see <http://www.gnu.org/licenses/>.

    Please send bug reports with examples or suggestions to
    contact@beem-project.com or http://dev.beem-project.com/
 */

package com.beem.project.beem.account;

import android.app.Service;
import android.content.Intent;
import android.os.IBinder;

/**
 * Class to integrate beem in android's account 
 * @author marseille
 */

public class AuthenticatorService extends Service {

    private Authenticator mAuth;

    /**
     * Constructor
     */
    public AuthenticatorService() {
	super();
    }
    
    /**
     * {@inheritDoc}
     */
    @Override
    public void onCreate() {
	super.onCreate();
	mAuth = new Authenticator(getApplicationContext());
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public IBinder onBind(Intent intent) {
	IBinder ret = null;
	if (intent.getAction().equals(android.accounts.AccountManager.ACTION_AUTHENTICATOR_INTENT))
	    ret = mAuth.getIBinder();
	return ret;
    }

}
