[![Release Version](https://img.shields.io/maven-central/v/com.geekorum.aboutoss/core?label=release)](https://search.maven.org/#search%7Cga%7C1%7Caboutoss)
[![License](https://img.shields.io/github/license/fbarthelery/AboutOss)](https://github.com/fbarthelery/AboutOss/blob/main/LICENSE)

AboutOss
==========

AboutOss is a Kotlin Multiplatform utility library to retrieve and display opensource licenses in your applications.

```kotlin title="build.gradle.kts"
implementation("com.geekorum.aboutoss:ui-material3:<latest-version>")
```

License sources
---------------

The library can work with license information files generated by:

- [OSS Licenses Gradle Plugin](https://github.com/google/play-services-plugins/tree/main/oss-licenses-plugin)
- [licensee](https://github.com/cashapp/licensee)
- [LicensePlist](https://github.com/mono0926/LicensePlist)

See [license sources](https://fbarthelery.github.io/AboutOss/license-sources/) for more information

User interface
--------------

The user interface to display license information is written in [Compose Multiplatform](https://github.com/JetBrains/compose-multiplatform).
There is out of the box composables for Material and Material3 and you can easily write your own UI.

Check the sample [here](https://github.com/fbarthelery/AboutOss/tree/main/sample) 

Build instructions
==================

Just use Gradle to build

    ./gradlew build


License
=======

AboutOss is an open source library and is licensed under the GNU General Public License 3 and any later version.
This means that you can get AboutOss's code and modify it to suit your needs, as long as you publish the changes
you make for everyone to benefit from as well.

AboutOss is built and maintained by community volunteers.
