/*
 * AboutOss is a utility library to retrieve and display
 * opensource licenses in Android applications.
 *
 * Copyright (C) 2023-2025 by Frederic-Charles Barthelery.
 *
 * This file is part of AboutOss.
 *
 * AboutOss is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * AboutOss is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with AboutOss.  If not, see <http://www.gnu.org/licenses/>.
 */
package com.geekorum.build

import com.vanniktech.maven.publish.MavenPublishBaseExtension
import com.vanniktech.maven.publish.MavenPublishPlugin
import org.gradle.api.Project
import org.gradle.kotlin.dsl.apply
import org.gradle.kotlin.dsl.configure

internal fun Project.configureMavenPublish() {
    apply<MavenPublishPlugin>()

    configure<MavenPublishBaseExtension>() {
//        TODO
//        publishToMavenCentral(SonatypeHost.DEFAULT)
//        signAllPublications()

        // default pom info. each field can be overridden in specific project
        pom {
            name.set(project.name)
            description.set("A library to retrieve and display opensource licenses in applications")
            inceptionYear.set("2023")
            val githubUrl = "https://github.com/fbarthelery/AboutOss/"
            url.set(githubUrl)
            scm {
                url.set(githubUrl)
                connection.set("scm:git:$githubUrl.git")
            }

            licenses {
                license {
                    name.set("GPL-3.0-or-later")
                    url.set("https://www.gnu.org/licenses/gpl-3.0.html")
                    distribution.set("repo")
                }
            }

            developers {
                developer {
                    id.set("da_risk")
                    name.set("Frédéric Barthéléry")
                    email.set("da_risk@geekorum.com")
                }
            }
        }
    }

}