/*
 * AboutOss is a utility library to retrieve and display
 * opensource licenses in Android applications.
 *
 * Copyright (C) 2023-2025 by Frederic-Charles Barthelery.
 *
 * This file is part of AboutOss.
 *
 * AboutOss is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * AboutOss is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with AboutOss.  If not, see <http://www.gnu.org/licenses/>.
 */
package com.geekorum.build.conventions

import com.android.build.api.dsl.KotlinMultiplatformAndroidLibraryTarget
import com.android.build.gradle.BaseExtension
import org.gradle.api.Project
import org.gradle.api.plugins.ExtensionAware
import org.gradle.kotlin.dsl.findByType
import org.jetbrains.kotlin.gradle.dsl.KotlinMultiplatformExtension


fun Project.conventionForAndroidProject() {
    // new androidLibrary in multiplatform project
    extensions.findByType<KotlinMultiplatformExtension>()?.apply {
        (this as ExtensionAware).extensions.findByType<KotlinMultiplatformAndroidLibraryTarget>()?.apply {
            compileSdk = 36
            minSdk = 28
            aarMetadata {
                minCompileSdk = 28
            }
        }
    }

    extensions.findByType<BaseExtension>()?.apply {
        setCompileSdkVersion(36)
        defaultConfig {
            minSdk = 28
            aarMetadata {
                minCompileSdk = 28
            }
        }
    }
}
